/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx.preprocessor;

import com.google.common.collect.ImmutableMap;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.cxx.api.CppPunctuator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordChannel
extends Channel<Lexer> {
    private final Map<String, TokenType> keywordsMap;
    private final StringBuilder tmpBuilder = new StringBuilder();
    private final Matcher matcher;
    private final Token.Builder tokenBuilder = Token.builder();

    public KeywordChannel(String regexp, TokenType[] ... keywordSets) {
        ImmutableMap.Builder keywordsMapBuilder = ImmutableMap.builder();
        TokenType[][] arr$ = keywordSets;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TokenType[] keywords;
            for (TokenType keyword : keywords = arr$[i$]) {
                keywordsMapBuilder.put((Object)keyword.getValue(), (Object)keyword);
            }
        }
        this.keywordsMap = keywordsMapBuilder.build();
        this.matcher = Pattern.compile(regexp).matcher("");
    }

    public boolean consume(CodeReader code, Lexer lexer) {
        if (code.popTo(this.matcher, (Appendable)this.tmpBuilder) > 0) {
            String word = this.tmpBuilder.toString();
            this.tmpBuilder.delete(0, this.tmpBuilder.length());
            String identifier = word.substring(1, word.length()).trim();
            String potentialKeyword = CppPunctuator.HASH.getValue() + identifier;
            TokenType keywordType = this.keywordsMap.get(potentialKeyword);
            if (keywordType != null) {
                Token token = this.tokenBuilder.setType(keywordType).setValueAndOriginalValue(potentialKeyword).setURI(lexer.getURI()).setLine(code.getPreviousCursor().getLine()).setColumn(code.getPreviousCursor().getColumn()).build();
                lexer.addToken(new Token[]{token});
            } else {
                lexer.addToken(new Token[]{this.tokenBuilder.setType((TokenType)CppPunctuator.HASH).setValueAndOriginalValue(CppPunctuator.HASH.getValue()).setURI(lexer.getURI()).setLine(code.getPreviousCursor().getLine()).setColumn(code.getPreviousCursor().getColumn()).build()});
                lexer.addToken(new Token[]{this.tokenBuilder.setType((TokenType)GenericTokenType.IDENTIFIER).setValueAndOriginalValue(identifier).setURI(lexer.getURI()).setLine(code.getPreviousCursor().getLine()).setColumn(code.getPreviousCursor().getColumn()).build()});
            }
            return true;
        }
        return false;
    }
}

