/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.cxx.preprocessor;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodeProvider {
    private List<File> includeRoots = new LinkedList<File>();
    public static final Logger LOG = LoggerFactory.getLogger((String)"SourceCodeProvider");

    public void setIncludeRoots(List<String> includeRoots, String baseDir) {
        for (String tmp : includeRoots) {
            File includeRoot = new File(tmp);
            if (!includeRoot.isAbsolute()) {
                includeRoot = new File(baseDir, tmp);
            }
            try {
                includeRoot = includeRoot.getCanonicalFile();
            }
            catch (IOException io) {
                LOG.error("cannot get canonical form of: '{}'", (Object)includeRoot);
            }
            if (includeRoot.isDirectory()) {
                LOG.debug("storing include root: '{}'", (Object)includeRoot);
                this.includeRoots.add(includeRoot);
                continue;
            }
            LOG.warn("the include root {} doesnt exist", (Object)includeRoot.getAbsolutePath());
        }
    }

    public File getSourceCodeFile(String filename, String cwd, boolean quoted) {
        File result;
        block7: {
            File abspath;
            File file;
            block6: {
                result = null;
                file = new File(filename);
                if (!file.isAbsolute()) break block6;
                if (!file.isFile()) break block7;
                result = file;
                break block7;
            }
            if (quoted && (abspath = new File(new File(cwd), file.getPath())).isFile()) {
                result = abspath;
            }
            if (result == null) {
                for (File folder : this.includeRoots) {
                    File abspath2 = new File(folder.getPath(), filename);
                    if (!abspath2.isFile()) continue;
                    result = abspath2;
                    break;
                }
            }
        }
        if (result != null) {
            try {
                result = result.getCanonicalFile();
            }
            catch (IOException io) {
                LOG.error("cannot get canonical form of: '{}'", (Object)result);
            }
        }
        return result;
    }

    public String getSourceCode(File file) {
        String code = null;
        if (file.isFile()) {
            try {
                code = FileUtils.readFileToString((File)file);
            }
            catch (IOException e) {
                LOG.error("Cannot read contents of the file '{}'", (Object)file);
            }
        }
        return code;
    }
}

