/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.coverage;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.cxx.coverage.CoverageParser;
import org.sonar.plugins.cxx.utils.CxxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BullseyeParser
implements CoverageParser {
    private String prevLine;
    private int totaldecisions;
    private int totalcovereddecisions;
    private int totalconditions;
    private int totalcoveredconditions;

    @Override
    public void parseReport(File xmlFile, final Map<String, CoverageMeasuresBuilder> coverageData) throws XMLStreamException {
        CxxUtils.LOG.info("Bullseye - Parsing report '{}'", (Object)xmlFile);
        StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

            public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                rootCursor.advance();
                BullseyeParser.this.collectCoverage2(rootCursor.getAttrValue("dir"), rootCursor.childElementCursor("folder"), coverageData);
            }
        });
        parser.parse(xmlFile);
    }

    private void collectCoverage2(String refPath, SMInputCursor folder, Map<String, CoverageMeasuresBuilder> coverageData) throws XMLStreamException {
        LinkedList<String> path = new LinkedList<String>();
        while (folder.getNext() != null) {
            String folderName = folder.getAttrValue("name");
            path.add(folderName);
            this.recTreeWalk(refPath, folder, path, coverageData);
            path.removeLast();
        }
    }

    private void probWalk(SMInputCursor prob, CoverageMeasuresBuilder fileMeasuresBuilderIn) throws XMLStreamException {
        String line = prob.getAttrValue("line");
        String kind = prob.getAttrValue("kind");
        String event = prob.getAttrValue("event");
        if (!line.equals(this.prevLine)) {
            this.saveConditions(fileMeasuresBuilderIn);
        }
        this.updateMeasures(kind, event, line, fileMeasuresBuilderIn);
        this.prevLine = line;
    }

    private void funcWalk(SMInputCursor func, CoverageMeasuresBuilder fileMeasuresBuilderIn) throws XMLStreamException {
        SMInputCursor prob = func.childElementCursor();
        while (prob.getNext() != null) {
            this.probWalk(prob, fileMeasuresBuilderIn);
        }
        this.saveConditions(fileMeasuresBuilderIn);
    }

    private void fileWalk(SMInputCursor file, CoverageMeasuresBuilder fileMeasuresBuilderIn) throws XMLStreamException {
        SMInputCursor func = file.childElementCursor();
        while (func.getNext() != null) {
            this.funcWalk(func, fileMeasuresBuilderIn);
        }
    }

    private void recTreeWalk(String refPath, SMInputCursor folder, List<String> path, Map<String, CoverageMeasuresBuilder> coverageData) throws XMLStreamException {
        SMInputCursor child = folder.childElementCursor();
        while (child.getNext() != null) {
            String folderChildName = child.getLocalName();
            String name = child.getAttrValue("name");
            path.add(name);
            if (folderChildName.equalsIgnoreCase("src")) {
                String fileName = "";
                Iterator<String> iterator = path.iterator();
                while (iterator.hasNext()) {
                    fileName = fileName + iterator.next() + "/";
                }
                if (new File(fileName = StringUtils.chop((String)fileName)).isAbsolute()) {
                    refPath = "";
                }
                CoverageMeasuresBuilder fileMeasuresBuilderIn = CoverageMeasuresBuilder.create();
                this.fileWalk(child, fileMeasuresBuilderIn);
                coverageData.put(refPath + fileName, fileMeasuresBuilderIn);
            } else {
                this.recTreeWalk(refPath, child, path, coverageData);
            }
            path.remove(path.size() - 1);
        }
    }

    private void saveConditions(CoverageMeasuresBuilder fileMeasuresBuilderIn) {
        if (this.totaldecisions > 0 || this.totalconditions > 0) {
            if (this.totalcovereddecisions == 0 && this.totalcoveredconditions == 0) {
                fileMeasuresBuilderIn.setHits(Integer.parseInt(this.prevLine), 0);
            } else {
                fileMeasuresBuilderIn.setHits(Integer.parseInt(this.prevLine), 1);
            }
            if (this.totalconditions > 0) {
                fileMeasuresBuilderIn.setConditions(Integer.parseInt(this.prevLine), this.totalconditions, this.totalcoveredconditions);
            } else {
                fileMeasuresBuilderIn.setConditions(Integer.parseInt(this.prevLine), 2, this.totalcovereddecisions);
            }
        }
        this.totaldecisions = 0;
        this.totalcovereddecisions = 0;
        this.totalconditions = 0;
        this.totalcoveredconditions = 0;
    }

    private void updateMeasures(String kind, String event, String line, CoverageMeasuresBuilder fileMeasuresBuilderIn) {
        if (kind.equalsIgnoreCase("decision") || kind.equalsIgnoreCase("condition")) {
            if (kind.equalsIgnoreCase("condition")) {
                this.totalconditions += 2;
                ++this.totalcoveredconditions;
                if (event.equalsIgnoreCase("full")) {
                    ++this.totalcoveredconditions;
                }
                if (event.equalsIgnoreCase("none")) {
                    --this.totalcoveredconditions;
                }
            } else {
                ++this.totaldecisions;
                this.totalcovereddecisions = 1;
                if (event.equalsIgnoreCase("full")) {
                    this.totalcovereddecisions = 2;
                }
                if (event.equalsIgnoreCase("none")) {
                    this.totalcovereddecisions = 0;
                }
            }
        } else if (event.equalsIgnoreCase("full")) {
            fileMeasuresBuilderIn.setHits(Integer.parseInt(line), 1);
        } else {
            fileMeasuresBuilderIn.setHits(Integer.parseInt(line), 0);
        }
    }
}

