/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.coverage;

import java.io.File;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.cxx.coverage.CoverageParser;
import org.sonar.plugins.cxx.utils.CxxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaParser
implements CoverageParser {
    @Override
    public void parseReport(File xmlFile, final Map<String, CoverageMeasuresBuilder> coverageData) throws XMLStreamException {
        CxxUtils.LOG.info("Parsing report '{}'", (Object)xmlFile);
        StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

            public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                rootCursor.advance();
                CoberturaParser.this.collectPackageMeasures(rootCursor.descendantElementCursor("package"), coverageData);
            }
        });
        parser.parse(xmlFile);
    }

    private void collectPackageMeasures(SMInputCursor pack, Map<String, CoverageMeasuresBuilder> coverageData) throws XMLStreamException {
        while (pack.getNext() != null) {
            this.collectFileMeasures(pack.descendantElementCursor("class"), coverageData);
        }
    }

    private void collectFileMeasures(SMInputCursor clazz, Map<String, CoverageMeasuresBuilder> coverageData) throws XMLStreamException {
        while (clazz.getNext() != null) {
            String fileName = clazz.getAttrValue("filename");
            CoverageMeasuresBuilder builder = coverageData.get(fileName);
            if (builder == null) {
                builder = CoverageMeasuresBuilder.create();
                coverageData.put(fileName, builder);
            }
            this.collectFileData(clazz, builder);
        }
    }

    private void collectFileData(SMInputCursor clazz, CoverageMeasuresBuilder builder) throws XMLStreamException {
        SMInputCursor line = clazz.childElementCursor("lines").advance().childElementCursor("line");
        while (line.getNext() != null) {
            int lineId = Integer.parseInt(line.getAttrValue("number"));
            long noHits = Long.parseLong(line.getAttrValue("hits"));
            if (noHits > Integer.MAX_VALUE) {
                CxxUtils.LOG.warn("Truncating the actual number of hits ({}) to the maximum number supported by Sonar ({})", (Object)noHits, (Object)Integer.MAX_VALUE);
                noHits = Integer.MAX_VALUE;
            }
            builder.setHits(lineId, (int)noHits);
            String isBranch = line.getAttrValue("branch");
            String text = line.getAttrValue("condition-coverage");
            if (!StringUtils.equals((String)isBranch, (String)"true") || !StringUtils.isNotBlank((String)text)) continue;
            String[] conditions = StringUtils.split((String)StringUtils.substringBetween((String)text, (String)"(", (String)")"), (String)"/");
            builder.setConditions(lineId, Integer.parseInt(conditions[1]), Integer.parseInt(conditions[0]));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

