/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.externalrules;

import java.io.File;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.cxx.utils.CxxReportSensor;

public class CxxExternalRulesSensor
extends CxxReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.cxx.externalrules.reportPath";
    private static final String DEFAULT_REPORT_PATH = "externalrules-reports/externalrules-result-*.xml";
    private RulesProfile profile;

    public CxxExternalRulesSensor(RuleFinder ruleFinder, Settings conf, RulesProfile profile) {
        super(ruleFinder, conf);
        this.profile = profile;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return super.shouldExecuteOnProject(project) && !this.profile.getActiveRulesByRepository("cxxexternal").isEmpty();
    }

    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    protected void processReport(final Project project, final SensorContext context, File report) throws XMLStreamException {
        StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

            public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                rootCursor.advance();
                SMInputCursor errorCursor = rootCursor.childElementCursor("error");
                while (errorCursor.getNext() != null) {
                    String file = errorCursor.getAttrValue("file");
                    String line = errorCursor.getAttrValue("line");
                    String id = errorCursor.getAttrValue("id");
                    String msg = errorCursor.getAttrValue("msg");
                    CxxExternalRulesSensor.this.saveViolation(project, context, "cxxexternal", file, line, id, msg);
                }
            }
        });
        parser.parse(report);
    }
}

