/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.valgrind;

import java.io.File;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.RuleFinder;
import org.sonar.plugins.cxx.utils.CxxReportSensor;
import org.sonar.plugins.cxx.utils.CxxUtils;
import org.sonar.plugins.cxx.valgrind.ValgrindError;
import org.sonar.plugins.cxx.valgrind.ValgrindFrame;
import org.sonar.plugins.cxx.valgrind.ValgrindReportParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxxValgrindSensor
extends CxxReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.cxx.valgrind.reportPath";
    private static final String DEFAULT_REPORT_PATH = "valgrind-reports/valgrind-result-*.xml";
    private RulesProfile profile;

    public CxxValgrindSensor(RuleFinder ruleFinder, Settings conf, RulesProfile profile) {
        super(ruleFinder, conf);
        this.profile = profile;
    }

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        return super.shouldExecuteOnProject(project) && !this.profile.getActiveRulesByRepository("valgrind").isEmpty();
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    @Override
    protected void processReport(Project project, SensorContext context, File report) throws XMLStreamException {
        ValgrindReportParser parser = new ValgrindReportParser();
        this.saveErrors(project, context, parser.parseReport(report));
    }

    void saveErrors(Project project, SensorContext context, Set<ValgrindError> valgrindErrors) {
        for (ValgrindError error : valgrindErrors) {
            ValgrindFrame frame = error.getLastOwnFrame(project.getFileSystem().getBasedir().getPath());
            if (frame != null) {
                this.saveViolation(project, context, "valgrind", frame.getPath(), frame.getLine(), error.getKind(), error.toString());
                continue;
            }
            CxxUtils.LOG.warn("Cannot find a project file to assign the valgrind error '{}' to", (Object)error);
        }
    }
}

