/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.valgrind;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.plugins.cxx.valgrind.ValgrindFrame;

class ValgrindStack {
    private List<ValgrindFrame> frames = new ArrayList<ValgrindFrame>();

    ValgrindStack() {
    }

    public void addFrame(ValgrindFrame frame) {
        this.frames.add(frame);
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (ValgrindFrame frame : this.frames) {
            res.append(frame);
            res.append("\n");
        }
        return res.toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (ValgrindFrame frame : this.frames) {
            builder.append((Object)frame);
        }
        return builder.toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValgrindStack other = (ValgrindStack)o;
        return this.hashCode() == other.hashCode();
    }

    public ValgrindFrame getLastOwnFrame(String basedir) {
        for (ValgrindFrame frame : this.frames) {
            if (!this.isInside(frame.getDir(), basedir)) continue;
            return frame;
        }
        return null;
    }

    private boolean isInside(String path, String folder) {
        return "".equals(path) ? false : path.startsWith(folder);
    }
}

