/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.veraxx;

import com.ctc.wstx.exc.WstxEOFException;
import com.ctc.wstx.exc.WstxUnexpectedCharException;
import java.io.File;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.cxx.utils.CxxReportSensor;
import org.sonar.plugins.cxx.utils.CxxUtils;
import org.sonar.plugins.cxx.utils.EmptyReportException;

public class CxxVeraxxSensor
extends CxxReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.cxx.vera.reportPath";
    private static final String DEFAULT_REPORT_PATH = "vera++-reports/vera++-result-*.xml";
    private RulesProfile profile;

    public CxxVeraxxSensor(RuleFinder ruleFinder, Settings conf, RulesProfile profile) {
        super(ruleFinder, conf);
        this.profile = profile;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return super.shouldExecuteOnProject(project) && !this.profile.getActiveRulesByRepository("vera++").isEmpty();
    }

    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    protected void processReport(final Project project, final SensorContext context, File report) throws XMLStreamException {
        try {
            StaxParser parser = new StaxParser(new StaxParser.XmlStreamHandler(){

                public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
                    try {
                        rootCursor.advance();
                    }
                    catch (WstxEOFException eofExc) {
                        throw new EmptyReportException();
                    }
                    SMInputCursor fileCursor = rootCursor.childElementCursor("file");
                    while (fileCursor.getNext() != null) {
                        String name = fileCursor.getAttrValue("name");
                        SMInputCursor errorCursor = fileCursor.childElementCursor("error");
                        while (errorCursor.getNext() != null) {
                            if (!name.equals("error")) {
                                String line = errorCursor.getAttrValue("line");
                                String message = errorCursor.getAttrValue("message");
                                String source = errorCursor.getAttrValue("source");
                                CxxVeraxxSensor.this.saveViolation(project, context, "vera++", name, line, source, message);
                                continue;
                            }
                            CxxUtils.LOG.debug("Error in file '{}', with message '{}'", (Object)errorCursor.getAttrValue("line"), (Object)errorCursor.getAttrValue("message"));
                        }
                    }
                }
            });
            parser.parse(report);
        }
        catch (WstxUnexpectedCharException e) {
            CxxUtils.LOG.error("Ignore XML error from Veraxx '{}'", (Object)e.toString());
        }
    }
}

