/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.xunit;

import org.apache.commons.lang.StringEscapeUtils;

public class TestCase {
    private static final String STATUS_OK = "ok";
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_FAILURE = "failure";
    private static final String STATUS_SKIPPED = "skipped";
    private String name;
    private String status = "ok";
    private String stackTrace;
    private String errorMessage;
    private int time = 0;

    public TestCase(String name, int time, String status, String stack, String msg) {
        this.name = name;
        this.time = time;
        this.stackTrace = stack;
        this.errorMessage = msg;
        this.status = status;
    }

    public boolean isError() {
        return STATUS_ERROR.equals(this.status);
    }

    public boolean isFailure() {
        return STATUS_FAILURE.equals(this.status);
    }

    public boolean isSkipped() {
        return STATUS_SKIPPED.equals(this.status);
    }

    public int getTime() {
        return this.time;
    }

    public String getDetails() {
        StringBuilder details = new StringBuilder();
        details.append("<testcase status=\"").append(this.status).append("\" time=\"").append(this.time).append("\" name=\"").append(this.name).append("\"");
        if (this.isError() || this.isFailure()) {
            details.append(">").append(this.isError() ? "<error message=\"" : "<failure message=\"").append(StringEscapeUtils.escapeXml((String)this.errorMessage)).append("\">").append("<![CDATA[").append(StringEscapeUtils.escapeXml((String)this.stackTrace)).append("]]>").append(this.isError() ? "</error>" : "</failure>").append("</testcase>");
        } else {
            details.append("/>");
        }
        return details.toString();
    }
}

