/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cxx.xunit;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.cxx.xunit.TestCase;

public class TestSuite {
    private String key;
    private int errors = 0;
    private int skipped = 0;
    private int tests = 0;
    private int time = 0;
    private int failures = 0;
    private List<TestCase> testCases;

    public TestSuite(String key) {
        this.key = key;
        this.testCases = new ArrayList<TestCase>();
    }

    public String getKey() {
        return this.key;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public int getTests() {
        return this.tests;
    }

    public int getTime() {
        return this.time;
    }

    public int getFailures() {
        return this.failures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestSuite that = (TestSuite)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public void addTestCase(TestCase tc) {
        if (tc.isSkipped()) {
            ++this.skipped;
        } else if (tc.isFailure()) {
            ++this.failures;
        } else if (tc.isError()) {
            ++this.errors;
        }
        ++this.tests;
        this.time += tc.getTime();
        this.testCases.add(tc);
    }

    public String getDetails() {
        StringBuilder details = new StringBuilder();
        details.append("<tests-details>");
        for (TestCase tc : this.testCases) {
            details.append(tc.getDetails());
        }
        details.append("</tests-details>");
        return details.toString();
    }
}

