/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.dotnet.AbstractDotNetMojo;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractDotNetBuildMojo
extends AbstractDotNetMojo {
    private String dotnet_2_0_sdk_directory;
    private String dotnet_3_5_sdk_directory;
    private String dotnet_4_0_sdk_directory;
    protected String toolVersion;
    protected boolean parallelBuild;

    protected final File getMsBuildCommand() throws MojoExecutionException {
        String commandName = "MSBuild.exe";
        File executable = "2.0".equals(this.toolVersion) ? new File(this.dotnet_2_0_sdk_directory, commandName) : ("4.0".equals(this.toolVersion) ? new File(this.dotnet_4_0_sdk_directory, commandName) : new File(this.dotnet_3_5_sdk_directory, commandName));
        if (!executable.exists()) {
            throw new MojoExecutionException("Could not find the MSBuild executable for the version " + this.toolVersion + ". Please " + "ensure you have properly defined the properties 'dotnet.2.0.sdk.directory' " + "or 'dotnet.3.5.sdk.directory' or 'dotnet.4.0.sdk.directory'");
        }
        return executable;
    }

    protected final List<String> getBuildConfigurations() {
        List<String> result = StringUtils.isEmpty((String)this.buildConfigurations) ? Collections.EMPTY_LIST : Arrays.asList(StringUtils.split((String)this.buildConfigurations, (String)",; "));
        return result;
    }
}

