/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.dotnet.Java5CommandLine;
import org.apache.maven.dotnet.commons.project.DotNetProjectException;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.dotnet.commons.project.VisualStudioUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractDotNetMojo
extends AbstractMojo {
    private static final String CONTENT_FILE_NAME = "content.txt";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected String solutionName;
    protected String projectName;
    protected String testProjectPattern;
    protected String buildConfigurations;
    protected boolean generatePdb;
    protected boolean useEmbbededRuntime;
    protected File outputDirectory;
    protected MavenProject project;
    protected boolean traceCommands = false;
    protected String skippedProjects;
    protected Map<String, String> assemblyDirectories = new HashMap<String, String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.checkExecutionAllowed()) {
            return;
        }
        if (VisualStudioUtils.SOLUTION_PACKAGINGS.contains(this.project.getPackaging())) {
            VisualStudioSolution visualSolution = null;
            try {
                visualSolution = VisualStudioUtils.getVisualSolution((MavenProject)this.project, (String)this.solutionName);
            }
            catch (DotNetProjectException e) {
                throw new MojoExecutionException("The solution for project " + this.project.getArtifactId() + " is not a " + "properly configured Visual Studio solution.\nPlease ensure you have a '.sln' file in " + this.project.getBasedir(), (Exception)((Object)e));
            }
            if (visualSolution == null) {
                throw new MojoExecutionException("The solution for project " + this.project.getArtifactId() + " is not a " + "properly configured Visual Studio solution.\nPlease ensure you have a '.sln' file in " + this.project.getBasedir());
            }
            if ("ALL".equals(this.buildConfigurations)) {
                this.buildConfigurations = StringUtils.join((Collection)visualSolution.getBuildConfigurations(), (char)',');
            }
            if (this.assemblyDirectories != null) {
                visualSolution.overrideAssemblyDirectories(this.assemblyDirectories);
            }
            visualSolution.filterProjects(this.skippedProjects);
            this.executeSolution(visualSolution);
            return;
        }
        VisualStudioProject visualProject = this.getVisualProject();
        if (visualProject == null) {
            this.getLog().info((CharSequence)("The project " + this.project.getArtifactId() + " is not a visual studio project"));
            return;
        }
        this.executeProject(visualProject);
    }

    protected abstract void executeProject(VisualStudioProject var1) throws MojoExecutionException, MojoFailureException;

    protected abstract void executeSolution(VisualStudioSolution var1) throws MojoExecutionException, MojoFailureException;

    protected final VisualStudioProject getVisualProject() throws MojoExecutionException {
        File projectFile;
        try {
            projectFile = VisualStudioUtils.getVisualFile((MavenProject)this.project, (String)this.projectName, (String)".csproj", (String)"project");
        }
        catch (DotNetProjectException except) {
            throw new MojoExecutionException("Could not create a VisualStudio project", (Exception)((Object)except));
        }
        if (projectFile == null) {
            this.getLog().debug((CharSequence)("The project " + this.project.getName() + " is not a Visual Studio project"));
            return null;
        }
        try {
            VisualStudioProject visualProject = VisualStudioUtils.getProject((File)projectFile);
            this.assessTestProject(visualProject);
            return visualProject;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Could not extract the project information for " + projectFile, (Exception)e);
        }
        catch (DotNetProjectException e) {
            throw new MojoExecutionException("Could not extract the project information for " + projectFile, (Exception)((Object)e));
        }
    }

    protected final VisualStudioSolution getVisualSolution() throws MojoExecutionException {
        VisualStudioSolution solution;
        File solutionFile;
        File basedir = this.project.getBasedir();
        try {
            solutionFile = VisualStudioUtils.getVisualFile((MavenProject)this.project, (String)this.solutionName, (String)".sln", (String)"solution");
        }
        catch (DotNetProjectException except) {
            throw new MojoExecutionException("Could not create a VisualStudio solution", (Exception)((Object)except));
        }
        if (solutionFile == null) {
            this.getLog().debug((CharSequence)("The project " + this.project.getName() + " is not a Visual Studio solution"));
            return null;
        }
        this.solutionName = solutionFile.getName();
        try {
            solution = VisualStudioUtils.getSolution((File)basedir, (String)this.solutionName);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not extract the solution information for " + solutionFile, e);
        }
        List projects = solution.getProjects();
        for (VisualStudioProject visualStudioProject : projects) {
            this.assessTestProject(visualStudioProject);
        }
        return solution;
    }

    private void assessTestProject(VisualStudioProject visualStudioProject) {
        VisualStudioUtils.assessTestProject((VisualStudioProject)visualStudioProject, (String)this.testProjectPattern);
    }

    protected void deleteFiles(File ... files) {
        for (File file : files) {
            if (!file.exists()) continue;
            file.delete();
        }
    }

    protected void ensureWindowsSystem() throws MojoExecutionException {
        String osName = System.getProperty("os.name").toLowerCase();
        if (!osName.contains("windows")) {
            throw new MojoExecutionException("The task must be launched on a Windows system");
        }
    }

    protected void ensureJavaVersion() throws MojoExecutionException {
        String version = System.getProperty("java.version");
        int versionValue = Integer.parseInt("" + version.charAt(0) + version.charAt(2));
        if (versionValue < 16) {
            throw new MojoExecutionException("The C# reporting plugin requires to be run in at least the JDK 6.0");
        }
    }

    protected int launchCommand(File executable, List<String> arguments, String reportType, int acceptedMask) throws MojoExecutionException, MojoFailureException {
        Commandline commandline = this.generateCommandLine(executable, arguments);
        return this.launchCommand(commandline, reportType, acceptedMask, true);
    }

    protected int launchCommand(Commandline commandline, String reportType, int acceptedMask, boolean throwsFailure) throws MojoExecutionException, MojoFailureException {
        int commandLineResult;
        Log log = this.getLog();
        Object[] commandLineElements = commandline.getCommandline();
        CommandStreamConsumer systemOut = new CommandStreamConsumer(log);
        try {
            log.debug((CharSequence)("Executing command: " + commandline));
            log.debug((CharSequence)("Command elements :" + Arrays.toString(commandLineElements)));
            ProcessBuilder builder = new ProcessBuilder(Arrays.asList(commandLineElements));
            builder.redirectErrorStream(true);
            if (this.traceCommands) {
                try {
                    File commandFile = this.getReportFile("command.txt");
                    FileOutputStream stream = new FileOutputStream(commandFile, true);
                    PrintWriter writer = new PrintWriter(stream);
                    writer.println("Mojo : " + reportType + " on " + new Timestamp(System.currentTimeMillis()));
                    writer.println(commandline);
                    writer.println();
                    writer.close();
                }
                catch (FileNotFoundException e) {
                    log.debug((CharSequence)"command.txt not found");
                }
            }
            commandLineResult = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)systemOut, (StreamConsumer)systemOut);
            if (systemOut.isCommandNotFound()) {
                throw new MojoExecutionException("Please add the executable for " + reportType + " to your path");
            }
            if ((commandLineResult & ~acceptedMask) != 0) {
                if (log.isWarnEnabled()) {
                    log.warn((CharSequence)"FAILURE !!!");
                    log.warn((CharSequence)("Launched command : " + commandline));
                    log.warn((CharSequence)"");
                    log.warn(systemOut.getContent());
                }
                if (throwsFailure) {
                    throw new MojoFailureException("Failure during the " + reportType + " generation that ended with status=" + commandLineResult);
                }
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failure during the " + reportType + " generation, executing commandline:\n" + commandline, (Exception)((Object)e));
        }
        return commandLineResult;
    }

    protected Commandline generateCommandLine(File executable, List<String> arguments) {
        Java5CommandLine commandline = new Java5CommandLine();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        commandline.setWorkingDirectory(this.outputDirectory.toString());
        commandline.setExecutable(executable.toString());
        commandline.addArguments(arguments.toArray(EMPTY_STRING_ARRAY));
        return commandline;
    }

    protected File extractFolder(String resourceDir, String destinationSubFolder, String application) throws MojoExecutionException {
        if (!this.useEmbbededRuntime) {
            this.getLog().warn((CharSequence)"The use of the embedded runtime package is not enabled. Please add the settings 'dotnet.use.embedded.runtime=true'");
            throw new MojoExecutionException("The use of the embedded runtime package is not enabled for " + application);
        }
        this.getLog().debug((CharSequence)("Exporting files for " + application));
        String contentFile = resourceDir + "/" + CONTENT_FILE_NAME;
        InputStream contentResource = this.getClassLoader().getResourceAsStream(contentFile);
        if (contentResource == null) {
            throw new MojoExecutionException(application + " binaries were not found");
        }
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(contentResource));
        String line = null;
        ArrayList<String> contentFiles = new ArrayList<String>();
        try {
            while ((line = reader.readLine()) != null) {
                contentFiles.add(line.trim());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not extract the files for " + application, (Exception)e);
        }
        File reportDirectory = this.getReportDirectory();
        File extractFolder = new File(reportDirectory, destinationSubFolder);
        this.extractResources(extractFolder, resourceDir, contentFiles, application);
        return extractFolder;
    }

    protected void extractResources(File destinationDirectory, String resourceDirectory, List<String> resourceNames, String application) throws MojoExecutionException {
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdirs();
        }
        for (String resource : resourceNames) {
            this.extractResource(destinationDirectory, resourceDirectory + "/" + resource, resource, application);
        }
    }

    protected File extractResource(File exportDirectory, String resourcePath, String fileName, String application) throws MojoExecutionException {
        File exportedFile = new File(exportDirectory, fileName);
        File parentDirectory = exportedFile.getParentFile();
        if (!parentDirectory.exists()) {
            this.getLog().debug((CharSequence)("Creating parent export directory : " + parentDirectory));
            parentDirectory.mkdirs();
        }
        if (exportedFile.exists()) {
            exportedFile.delete();
        }
        try {
            int len;
            exportedFile.createNewFile();
            InputStream fileStream = this.getClassLoader().getResourceAsStream(resourcePath);
            FileOutputStream out = new FileOutputStream(exportedFile);
            long length = 0L;
            byte[] buf = new byte[1024];
            while ((len = fileStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
                length += (long)len;
            }
            ((OutputStream)out).close();
            fileStream.close();
            this.getLog().debug((CharSequence)("Exported file " + exportedFile + " : " + length + " bytes"));
        }
        catch (Exception e) {
            throw new MojoExecutionException("A problem occurred for " + application + " while extracting file " + fileName + " to " + exportedFile, e);
        }
        return exportedFile;
    }

    protected File getReportFile(String fileName) {
        File reportDirectory = this.getReportDirectory();
        return new File(reportDirectory, fileName);
    }

    protected String toCommandPath(File file) {
        String absolutePath;
        try {
            absolutePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            absolutePath = file.getAbsolutePath();
        }
        return absolutePath;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected File getReportDirectory() {
        String buildPath = this.project.getBuild().getDirectory();
        File reportDirectory = new File(buildPath);
        reportDirectory.mkdirs();
        return reportDirectory;
    }

    protected boolean checkExecutionAllowed() throws MojoExecutionException {
        this.ensureWindowsSystem();
        this.ensureJavaVersion();
        return true;
    }

    private static final class CommandStreamConsumer
    implements StreamConsumer {
        private static final String COMMAND_NOT_FOUND_FRAGMENT = "is not recognized as an internal or external command";
        private boolean commandNotFound;
        private StringBuilder consumedLines = new StringBuilder();
        private Log log;

        private CommandStreamConsumer(Log log) {
            this.log = log;
        }

        public void consumeLine(String line) {
            this.consumedLines.append(line + "\n");
            this.log.info((CharSequence)line);
            if (line.contains(COMMAND_NOT_FOUND_FRAGMENT)) {
                this.commandNotFound = true;
            }
        }

        public boolean isCommandNotFound() {
            return this.commandNotFound;
        }

        public CharSequence getContent() {
            return this.consumedLines;
        }
    }
}

