/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.dotnet.AbstractDotNetMojo;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractUnitTestMojo
extends AbstractDotNetMojo {
    protected List<File> extractTestAssemblies(VisualStudioSolution solution) throws MojoFailureException {
        List projects = solution.getTestProjects();
        ArrayList<File> testAssemblies = new ArrayList<File>();
        for (VisualStudioProject visualProject : projects) {
            File generatedAssembly = visualProject.getArtifact(this.buildConfigurations);
            if (generatedAssembly.exists()) {
                testAssemblies.add(generatedAssembly);
                continue;
            }
            this.getLog().warn((CharSequence)("Skipping missing test assembly " + generatedAssembly));
        }
        return testAssemblies;
    }

    @Override
    protected boolean checkExecutionAllowed() throws MojoExecutionException {
        Log log = this.getLog();
        String skipTest = System.getProperty("maven.test.skip");
        if ("TRUE".equalsIgnoreCase(skipTest)) {
            log.info((CharSequence)"Skipping Test Execution");
            return false;
        }
        return super.checkExecutionAllowed();
    }
}

