/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.dotnet.AbstractDotNetMojo;
import org.apache.maven.dotnet.SrcMonCommandGenerator;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public class CodeMetricsMojo
extends AbstractDotNetMojo {
    private static final String RESOURCE_DIR = "metrics";
    private static final String EXPORT_PATH = "sourcemonitor-runtime";
    private File sourceMonitorDirectory;
    private String sourceMonitorExecutable;
    private String excludedSubTree;
    private String[] excludedExtensions = new String[]{"*.Designer.cs"};
    private String metricsReportFileName;
    private File metricsSrcDirectory;

    @Override
    protected void executeSolution(VisualStudioSolution solution) throws MojoExecutionException, MojoFailureException {
        SrcMonCommandGenerator generator = new SrcMonCommandGenerator();
        generator.setExcludedExtensions(Arrays.asList(this.excludedExtensions));
        String version = this.project.getVersion();
        generator.setCheckPointName(version);
        File outputFile = this.getReportFile(this.metricsReportFileName);
        File projectFile = this.getReportFile(this.metricsReportFileName + ".smp");
        File workDirectory = this.getReportDirectory();
        this.deleteFiles(outputFile, projectFile);
        generator.setGeneratedFile(outputFile.toString());
        generator.setWorkDirectory(workDirectory);
        generator.setSourcePath(this.metricsSrcDirectory.toString());
        File sourceMonitorExe = this.getExecutable();
        generator.setSourceMonitorPath(sourceMonitorExe.toString());
        generator.setProjectFile(projectFile.toString());
        ArrayList<VisualStudioProject> excludedProjects = new ArrayList<VisualStudioProject>(solution.getTestProjects());
        if (this.skippedProjects != null) {
            HashSet<String> skippedProjectNameSet = new HashSet<String>();
            skippedProjectNameSet.addAll(Arrays.asList(StringUtils.split((String)this.skippedProjects, (String)",")));
            List projects = solution.getProjects();
            for (VisualStudioProject visualStudioProject : projects) {
                if (!skippedProjectNameSet.contains(visualStudioProject.getName())) continue;
                excludedProjects.add(visualStudioProject);
            }
        }
        for (VisualStudioProject visualStudioProject : excludedProjects) {
            File directory = visualStudioProject.getDirectory();
            try {
                URI directoryUri = directory.getCanonicalFile().toURI();
                URI solutionUri = this.metricsSrcDirectory.getCanonicalFile().toURI();
                String relativePath = solutionUri.relativize(directoryUri).getPath();
                generator.addExcludedDirectory(relativePath);
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Could not compute the relative path for the project " + visualStudioProject), (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)("Launching metrics generation for solution " + solution.getName()));
        try {
            File commandFile = generator.generateCommandFile();
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("/C");
            arguments.add(this.toCommandPath(commandFile));
            this.launchCommand(sourceMonitorExe, arguments, "Metrics", 1);
            this.getLog().info((CharSequence)"Metrics generated!");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not execute source monitor", e);
        }
    }

    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoFailureException, MojoExecutionException {
        SrcMonCommandGenerator generator = new SrcMonCommandGenerator();
        String version = this.project.getVersion();
        generator.setCheckPointName(version);
        File outputFile = this.getReportFile(this.metricsReportFileName);
        File projectFile = this.getReportFile(this.metricsReportFileName + ".smp");
        this.deleteFiles(outputFile, projectFile);
        generator.setGeneratedFile(outputFile.toString());
        File projectDir = this.project.getBasedir();
        generator.setSourcePath(projectDir.toString());
        File sourceMonitorExe = this.getExecutable();
        generator.setSourceMonitorPath(sourceMonitorExe.toString());
        generator.setProjectFile(projectFile.toString());
        this.getLog().info((CharSequence)("Launching metrics generation for project " + visualProject.getName()));
        try {
            generator.launch();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not execute source monitor", e);
        }
    }

    private File getExecutable() throws MojoFailureException, MojoExecutionException {
        File executable;
        if (this.sourceMonitorDirectory == null) {
            this.sourceMonitorDirectory = this.extractFolder(RESOURCE_DIR, EXPORT_PATH, "SourceMonitor");
        }
        if (!(executable = new File(this.sourceMonitorDirectory, this.sourceMonitorExecutable)).exists()) {
            this.getLog().error((CharSequence)("Cannot find the SourceMonitor executable :" + executable));
            this.getLog().error((CharSequence)"Please ensure that SourceMonitor is well installed and that the property source.monitor.directory is correctly defined or that the source.monitor.executable is correct in your settings.xml");
            throw new MojoFailureException("Cannot find the SourceMonitor directory");
        }
        return executable;
    }
}

