/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.dotnet.AbstractDotNetBuildMojo;
import org.apache.maven.dotnet.commons.project.ArtifactType;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class CompileMojo
extends AbstractDotNetBuildMojo {
    private boolean rebuild;
    private boolean disablePreBuildEvent;
    private boolean disablePostBuildEvent;
    private String platforms;

    @Override
    public void executeProject(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
        if (visualProject.getType() != ArtifactType.WEB) {
            File csprojFile = visualProject.getProjectFile();
            this.launchBuild(csprojFile);
        }
    }

    @Override
    public void executeSolution(VisualStudioSolution visualSolution) throws MojoExecutionException, MojoFailureException {
        File solutionFile = visualSolution.getSolutionFile();
        this.launchBuild(solutionFile);
    }

    public void launchBuild(File file) throws MojoExecutionException, MojoFailureException {
        File executable = this.getMsBuildCommand();
        List<String> configurations = this.getBuildConfigurations();
        for (String configuration : configurations) {
            String[] platformArray;
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(this.toCommandPath(file));
            if (this.rebuild) {
                arguments.add("/t:Rebuild");
            } else {
                arguments.add("/t:Build");
            }
            if (this.parallelBuild) {
                arguments.add("/m");
            }
            if (this.disablePostBuildEvent) {
                arguments.add("/p:PostBuildEvent=\"\"");
            }
            if (this.disablePreBuildEvent) {
                arguments.add("/p:PreBuildEvent=\"\"");
            }
            if (!this.generatePdb) {
                arguments.add("/p:DebugSymbols=false");
                arguments.add("/p:DebugType=None");
            }
            arguments.add("/p:Configuration=" + configuration);
            for (String platform : platformArray = StringUtils.split((String)this.platforms, (String)",;")) {
                ArrayList<String> platformArguments = new ArrayList<String>(arguments);
                platformArguments.add("/p:Platform=" + platform);
                Log log = this.getLog();
                log.info((CharSequence)("Launching the build of " + file));
                log.debug((CharSequence)(" - Tool Version  : " + this.toolVersion));
                log.debug((CharSequence)(" - MsBuild exe   : " + executable));
                log.debug((CharSequence)(" - Configuration : " + configuration + (this.rebuild ? " (force rebuild)" : "")));
                this.launchCommand(executable, platformArguments, "build", 0);
                log.info((CharSequence)("Build of " + this.solutionName + " in configuration " + configuration + " terminated with SUCCESS!"));
            }
        }
    }
}

