/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.CsLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.apache.maven.dotnet.AbstractDotNetMojo;
import org.apache.maven.dotnet.commons.project.SourceFile;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class CpdMojo
extends AbstractDotNetMojo {
    private int minimumTokens;
    private boolean skip;
    private String sourceEncoding;
    protected File outputReportingDirectory;
    protected String format = "xml";
    protected boolean includeTests;
    protected boolean aggregate;
    private String skippedProjects;

    protected MavenProject getProject() {
        return this.project;
    }

    protected Map<File, SourceFile> getFilesToProcess() throws MojoExecutionException {
        HashMap<File, SourceFile> fileMap = new HashMap<File, SourceFile>();
        FilenameFilter filter = new CsLanguage().getFileFilter();
        HashSet<String> skippedProjectSet = new HashSet<String>();
        if (this.skippedProjects != null) {
            skippedProjectSet.addAll(Arrays.asList(StringUtils.split((String)this.skippedProjects, (String)",")));
        }
        List projects = this.getVisualSolution().getProjects();
        for (VisualStudioProject visualStudioProject : projects) {
            if (visualStudioProject.isTest() && !this.includeTests) {
                this.getLog().debug((CharSequence)("skipping test project " + visualStudioProject.getName()));
                continue;
            }
            if (skippedProjectSet.contains(visualStudioProject.getName())) {
                this.getLog().info((CharSequence)("Skipping project " + visualStudioProject.getName()));
                continue;
            }
            Collection sources = visualStudioProject.getSourceFiles();
            for (SourceFile sourceFile : sources) {
                if (!filter.accept(sourceFile.getFile().getParentFile(), sourceFile.getName())) continue;
                fileMap.put(sourceFile.getFile(), sourceFile);
            }
        }
        return fileMap;
    }

    public boolean canGenerateReport() {
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return false;
        }
        if ("xml".equals(this.format)) {
            return true;
        }
        try {
            Map<File, SourceFile> filesToProcess = this.getFilesToProcess();
            if (filesToProcess.isEmpty()) {
                return false;
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().error((Throwable)e);
        }
        return true;
    }

    protected String getOutputReportingDirectory() {
        return this.outputReportingDirectory.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReport() throws MojoExecutionException {
        if (!this.skip && this.canGenerateReport()) {
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                CPD cpd = new CPD(this.minimumTokens, (Language)new CsLanguage());
                try {
                    Map<File, SourceFile> files = this.getFilesToProcess();
                    if (StringUtils.isNotEmpty((String)this.sourceEncoding)) {
                        cpd.setEncoding(this.sourceEncoding);
                    } else if (!files.isEmpty()) {
                        this.getLog().warn((CharSequence)"File encoding has not been set, using platform encoding , i.e. build is platform dependent!");
                    }
                    Set<File> fileSet = files.keySet();
                    for (File file : fileSet) {
                        cpd.add(file);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new MojoExecutionException("Encoding '" + this.sourceEncoding + "' is not supported.", (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                cpd.go();
                this.writeNonHtml(cpd);
            }
            finally {
                Thread.currentThread().setContextClassLoader(origLoader);
            }
        }
    }

    void writeNonHtml(CPD cpd) throws MojoExecutionException {
        Renderer r = this.createRenderer();
        String buffer = r.render(cpd.getMatches());
        try {
            this.outputDirectory.mkdirs();
            FileOutputStream tStream = new FileOutputStream(new File(this.outputDirectory, "cpd." + this.format));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)tStream, "UTF-8");
            ((Writer)writer).write(buffer, 0, buffer.length());
            ((Writer)writer).close();
            File siteDir = new File(this.outputDirectory, "site");
            siteDir.mkdirs();
            writer = new FileWriter(new File(siteDir, "cpd." + this.format));
            ((Writer)writer).write(buffer, 0, buffer.length());
            ((Writer)writer).close();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
    }

    public String getOutputName() {
        return "cpd";
    }

    public Renderer createRenderer() throws MojoExecutionException {
        XMLRenderer renderer = null;
        if ("xml".equals(this.format)) {
            renderer = new XMLRenderer("UTF-8");
        } else if ("csv".equals(this.format)) {
            renderer = new CSVRenderer();
        } else if (!"".equals(this.format) && !"none".equals(this.format)) {
            try {
                renderer = (Renderer)Class.forName(this.format).newInstance();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Can't find the custom format " + this.format + ": " + e.getClass().getName());
            }
        }
        if (renderer == null) {
            throw new MojoExecutionException("Can't create report with format of " + this.format);
        }
        return renderer;
    }

    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)("executeProject " + visualProject));
    }

    @Override
    protected void executeSolution(VisualStudioSolution visualSolution) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)("executeSolution " + visualSolution));
        this.executeReport();
    }
}

