/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.dotnet.AbstractDotNetBuildMojo;
import org.apache.maven.dotnet.commons.project.ArtifactType;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.dotnet.stylecop.StyleCopGenerator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class StyleCopMojo
extends AbstractDotNetBuildMojo {
    private static final String RESOURCE_DIR = "stylecop";
    private static final String EXPORT_PATH = "stylecop-runtime";
    private static final String STYLECOP_RULE_FILE = "default-rules.stylecop";
    private static final String STYLECOP_BUILD_FILE = "stylecop-msbuild.xml";
    private String styleCopRootPath;
    private File styleCopRoot;
    private String styleCopConfigPath;
    private String styleCopReportName;
    private String[] ignores;
    private File projectRoot;

    @Override
    public void executeSolution(VisualStudioSolution solution) throws MojoExecutionException, MojoFailureException {
        File solutionFile = solution.getSolutionFile();
        ArrayList<File> analyzedProjects = new ArrayList<File>();
        List allProjects = solution.getProjects();
        HashSet<String> skippedProjectSet = new HashSet<String>();
        if (this.skippedProjects != null) {
            skippedProjectSet.addAll(Arrays.asList(StringUtils.split((String)this.skippedProjects, (String)",")));
        }
        for (VisualStudioProject visualStudioProject : allProjects) {
            if (visualStudioProject.isTest() || skippedProjectSet.contains(visualStudioProject.getName())) continue;
            File file = visualStudioProject.getProjectFile();
            if (file == null) {
                file = visualStudioProject.getDirectory();
            }
            analyzedProjects.add(file);
        }
        this.launchReport(solutionFile, analyzedProjects);
    }

    @Override
    public void executeProject(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
        if (visualProject.getType() != ArtifactType.WEB) {
            File projectFile = visualProject.getProjectFile();
            this.launchReport(projectFile, Collections.singletonList(projectFile));
        }
    }

    private void launchReport(File solutionFile, List<File> projectFiles) throws MojoExecutionException, MojoFailureException {
        File styleCopConfigFile;
        Log log = this.getLog();
        this.extractExecutable();
        File reportDirectory = this.getReportDirectory();
        if (StringUtils.isEmpty((String)this.styleCopConfigPath)) {
            styleCopConfigFile = this.extractResource(reportDirectory, STYLECOP_RULE_FILE, STYLECOP_RULE_FILE, "stylecop rule file");
        } else {
            styleCopConfigFile = new File(this.styleCopConfigPath);
            if (!styleCopConfigFile.exists()) {
                throw new MojoExecutionException("Could not find the stylecop project file: " + styleCopConfigFile);
            }
        }
        File reportFile = this.getReportFile(this.styleCopReportName);
        File msbuildFile = this.getReportFile(STYLECOP_BUILD_FILE);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)"StyleCop configuration :");
            log.debug((CharSequence)(" - Solution file      : " + solutionFile));
            if (projectFiles != null && !projectFiles.isEmpty()) {
                log.debug((CharSequence)(" - Project files      :  " + projectFiles));
            }
            log.debug((CharSequence)(" - Config file        : " + styleCopConfigFile));
            log.debug((CharSequence)(" - Generated report   : " + reportFile));
            log.debug((CharSequence)(" - Excluded files     : " + Arrays.toString(this.ignores)));
            log.debug((CharSequence)(" - StyleCop directory : " + this.styleCopRootPath));
        }
        StyleCopGenerator generator = new StyleCopGenerator();
        generator.setOutput(reportFile);
        generator.setProjectRoot(this.projectRoot);
        generator.setSettings(styleCopConfigFile);
        generator.setStyleCopRoot(this.styleCopRoot);
        generator.setVisualSolution(solutionFile);
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                generator.addVisualProject(projectFile);
            }
        }
        try {
            FileOutputStream msBuildStream = new FileOutputStream(msbuildFile, false);
            generator.generate(msBuildStream);
            msBuildStream.close();
        }
        catch (IOException exc) {
            throw new MojoExecutionException("Could not generate the MSBuild file for StyleCop", (Exception)exc);
        }
        log.info((CharSequence)"StyleCop MsBuild file generated!");
        File executable = this.getMsBuildCommand();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("/p:AppRoot=" + this.toCommandPath(this.projectRoot));
        arguments.add("/target:CheckStyle");
        arguments.add(this.toCommandPath(msbuildFile));
        log.info((CharSequence)("Launching the build of " + msbuildFile));
        log.debug((CharSequence)(" - Tool Version  : " + this.toolVersion));
        log.debug((CharSequence)(" - MsBuild exe   : " + executable));
        this.launchCommand(executable, arguments, "build", 0);
        log.info((CharSequence)"StyleCop report generated");
    }

    private void extractExecutable() throws MojoExecutionException {
        this.styleCopRoot = StringUtils.isEmpty((String)this.styleCopRootPath) ? this.extractFolder(RESOURCE_DIR, EXPORT_PATH, "StyleCop") : new File(this.styleCopRootPath);
    }
}

