/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.dotnet.AbstractDotNetMojo;
import org.apache.maven.dotnet.commons.project.VisualStudioProject;
import org.apache.maven.dotnet.commons.project.VisualStudioSolution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.DirectoryWalkListener;
import org.codehaus.plexus.util.DirectoryWalker;
import org.codehaus.plexus.util.FileUtils;

public class UnPackMojo
extends AbstractDotNetMojo {
    static final int BIG_ARCHIVE_SIZE = 0xA00000;
    static final String LOCAL_DIR_NAME = "local";
    static final String DOTNET_DIR_NAME = "dotnet";
    static final String PROP_PREFIX = "dotnet.";
    static final String PROP_UNPACK_ROOT = "dotnet.unpack.root";
    static final String PROP_OFFSET = "dotnet.offset";
    static final String DOTNET_DUMP_CSPROJ_VARS = "dotnet.asp.file";
    private String unPackRoot;
    private String offset;
    private String csprojvars;
    private Set<String> dllDirs = new LinkedHashSet<String>();
    private ConsoleLogger consolLogger = new ConsoleLogger(3, "console");
    private ArtifactRepository localRepository;

    @Override
    protected void executeProject(VisualStudioProject visualProject) throws MojoExecutionException, MojoFailureException {
    }

    @Override
    protected void executeSolution(VisualStudioSolution visualSolution) throws MojoExecutionException, MojoFailureException {
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.dllDirs.clear();
        if (StringUtils.isEmpty((String)this.unPackRoot)) {
            this.unPackRoot = this.localRepository.getBasedir() + File.separator + DOTNET_DIR_NAME + File.separator + LOCAL_DIR_NAME;
        }
        if (this.offset == null) {
            this.offset = "";
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            File packagePath = new File(this.unPackRoot + File.separator + this.localRepository.pathOf(artifact));
            if (!packagePath.getParentFile().exists()) {
                this.unZipPackage(artifact, this.localRepository.pathOf(artifact));
                continue;
            }
            this.getLog().info((CharSequence)("UpToDate " + packagePath.getParentFile().getPath()));
            WatchedDirectoryWalkListener watchedDirectoryWalkListener = new WatchedDirectoryWalkListener(this.dllDirs, this.offset);
            DirectoryWalker dw = new DirectoryWalker();
            dw.setBaseDir(new File(packagePath.getParentFile().getPath()));
            dw.addDirectoryWalkListener((DirectoryWalkListener)watchedDirectoryWalkListener);
            try {
                dw.scan();
            }
            catch (IllegalStateException e) {
                throw new MojoExecutionException(packagePath.getParentFile().getPath() + " : " + e.getMessage(), (Exception)e);
            }
        }
        if (this.csprojvars != null) {
            this.getLog().info((CharSequence)("writing variables into file " + this.csprojvars));
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            PrintStream psOut = new PrintStream(baOut);
            psOut.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            psOut.println("  <Project ToolsVersion=\"3.5\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">");
            psOut.println("  <!-- Generated by DOTNET PLUGIN !-->");
            psOut.println("  <PropertyGroup>");
            psOut.println("  <AssemblySearchPaths>");
            psOut.print("  $(AssemblySearchPaths)");
            Iterator<String> iter = this.dllDirs.iterator();
            while (iter.hasNext()) {
                psOut.println(";");
                psOut.print("  " + iter.next());
            }
            psOut.println("");
            psOut.println("  </AssemblySearchPaths>");
            psOut.println("  </PropertyGroup>");
            psOut.println("</Project>");
            FileOutputStream fileOutputStreamOrder = null;
            try {
                fileOutputStreamOrder = new FileOutputStream(new File(this.csprojvars));
                fileOutputStreamOrder.write(baOut.toByteArray());
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Troubles during writing variables", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Troubles during writing variables", (Exception)e);
            }
            finally {
                if (fileOutputStreamOrder != null) {
                    try {
                        fileOutputStreamOrder.close();
                    }
                    catch (IOException e) {
                        this.getLog().info((Throwable)e);
                    }
                }
            }
        }
    }

    protected void unZipPackage(Artifact artifact, String packagePath) {
        if (artifact.getFile().exists()) {
            if (artifact.getFile().length() > 0xA00000L) {
                this.getLog().info((CharSequence)("  " + artifact.getFile().getName() + " is a big archive. Uncompressing may take a while..."));
            }
            try {
                WatchedZipUnArchiver zip = new WatchedZipUnArchiver(this.dllDirs, this.offset);
                zip.setSourceFile(artifact.getFile());
                zip.enableLogging((Logger)this.consolLogger);
                if (this.unPackRoot != null) {
                    File unPackRootFile = new File(this.unPackRoot + File.separator + packagePath).getParentFile();
                    unPackRootFile.mkdirs();
                    zip.setDestDirectory(unPackRootFile);
                } else {
                    zip.setDestDirectory(artifact.getFile().getParentFile());
                }
                zip.extract();
                this.getLog().info((CharSequence)("Unarchived " + artifact.getFile().length() + " bytes"));
            }
            catch (ArchiverException e) {
                this.getLog().warn((CharSequence)("Could not untar file " + artifact.getFile()), (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Could not untar file " + artifact.getFile()), (Throwable)e);
            }
        } else {
            this.getLog().info((CharSequence)("Nothing to untar !" + artifact.getFile()));
        }
    }

    private class WatchedDirectoryWalkListener
    implements DirectoryWalkListener {
        Set<String> dllDirs;
        String offset;
        private String baseDir;

        WatchedDirectoryWalkListener(Set<String> dllDirs, String offset) {
            this.dllDirs = dllDirs;
            this.offset = offset;
        }

        public void directoryWalkStarting(File baseDir) {
            this.baseDir = baseDir.getPath();
        }

        public void directoryWalkStep(int percentage, File file) {
            if (file.isFile() && file.getPath().startsWith(this.baseDir + File.separator + this.offset) && file.getName().endsWith(".dll")) {
                UnPackMojo.this.getLog().info((CharSequence)("Watched : " + file.getAbsolutePath()));
                this.dllDirs.add(file.getParent());
            }
        }

        public void directoryWalkFinished() {
        }

        public void debug(String arg0) {
            UnPackMojo.this.getLog().debug((CharSequence)arg0);
        }
    }

    private class WatchedZipUnArchiver
    extends ZipUnArchiver {
        Set<String> dllDirs;
        String offset;

        WatchedZipUnArchiver(Set<String> dllDirs, String offset) {
            this.dllDirs = dllDirs;
            this.offset = offset;
        }

        protected void extractFile(File srcF, File dir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws IOException {
            super.extractFile(srcF, dir, compressedInputStream, entryName, entryDate, isDirectory);
            File file = FileUtils.resolveFile((File)dir, (String)entryName);
            if (file.isFile() && file.getPath().startsWith(this.getDestDirectory().getPath() + File.separator + this.offset) && file.getName().endsWith(".dll")) {
                UnPackMojo.this.getLog().info((CharSequence)("Watched : " + file.getAbsolutePath()));
                this.dllDirs.add(file.getParent());
            }
        }
    }
}

