/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dotnet.stylecop;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.maven.dotnet.msbuild.xml.CreateItem;
import org.apache.maven.dotnet.msbuild.xml.ItemGroup;
import org.apache.maven.dotnet.msbuild.xml.ItemOutput;
import org.apache.maven.dotnet.msbuild.xml.Project;
import org.apache.maven.dotnet.msbuild.xml.PropertyGroup;
import org.apache.maven.dotnet.msbuild.xml.StyleCopTask;
import org.apache.maven.dotnet.msbuild.xml.Target;
import org.apache.maven.dotnet.msbuild.xml.UsingTask;

public class StyleCopGenerator {
    private static final String STYLE_COP_NAMESPACE = "http://schemas.microsoft.com/developer/msbuild/2003";
    private static final Logger log = LogManager.getLogger(StyleCopGenerator.class);
    private File projectRoot;
    private File styleCopRoot;
    private File visualSolution;
    private List<File> visualProjects;
    private File output;
    private File settings;

    public StyleCopGenerator(File styleCopRoot, File settings, File projectRoot, File visualSolution, List<File> visualProjects, File output) {
        this.styleCopRoot = styleCopRoot;
        this.settings = settings;
        this.projectRoot = projectRoot;
        this.visualSolution = visualSolution;
        this.visualProjects = visualProjects;
        this.output = output;
    }

    public StyleCopGenerator() {
        this.visualProjects = new ArrayList<File>();
    }

    public void generate(OutputStream stream) {
        Project project = new Project();
        PropertyGroup propGroup = new PropertyGroup();
        propGroup.setProjectRoot(this.toWindowsPath(this.projectRoot));
        propGroup.setStyleCopRoot(this.toWindowsPath(this.styleCopRoot));
        UsingTask usingTask = new UsingTask();
        usingTask.setAssemblyFile("$(StyleCopRoot)\\Microsoft.StyleCop.dll");
        usingTask.setTaskName("StyleCopTask");
        Target target = new Target();
        target.setName("CheckStyle");
        StyleCopTask task = new StyleCopTask();
        task.setFullPath(this.toWindowsPath(this.visualSolution));
        task.setOutputFile(this.toWindowsPath(this.output));
        task.setSettingsFile(this.toWindowsPath(this.settings));
        task.setSourceFiles("@(SourceAnalysisFiles);@(CSFile)");
        CreateItem createItem = new CreateItem();
        createItem.setInclude("%(Project.RootDir)%(Project.Directory)**\\*.cs");
        ItemOutput itemOutput = new ItemOutput();
        itemOutput.setTaskParameter("Include");
        itemOutput.setItemName("SourceAnalysisFiles");
        createItem.setOutput(itemOutput);
        ItemGroup group = new ItemGroup();
        for (File visualProject : this.visualProjects) {
            if (visualProject.isDirectory()) {
                group.addCsFiles(visualProject + "\\**\\*.cs");
                continue;
            }
            group.addProject(this.toWindowsPath(visualProject));
        }
        target.setItem(createItem);
        target.setStyleCopTask(task);
        project.setUsingTask(usingTask);
        project.setPropertyGroup(propGroup);
        project.setDefaultTargets("CheckStyle");
        project.setToolsVersion("3.5");
        project.addItem(group);
        project.addTarget(target);
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        StringWriter writer = new StringWriter();
        XMLStreamWriter xtw = null;
        try {
            xtw = xof.createXMLStreamWriter(writer);
            xtw.setNamespaceContext(new NamespaceContext(){

                public Iterator getPrefixes(String arg0) {
                    return null;
                }

                @Override
                public String getPrefix(String arg0) {
                    if (StyleCopGenerator.STYLE_COP_NAMESPACE.equals(arg0)) {
                        return "stylecop";
                    }
                    return null;
                }

                @Override
                public String getNamespaceURI(String arg0) {
                    return null;
                }
            });
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Project.class});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)project, xtw);
        }
        catch (Exception e) {
            log.debug((Object)"Generation error", (Throwable)e);
        }
        String xmlContent = writer.toString();
        String temp = StringUtils.replace((String)xmlContent, (String)"xmlns=\"\"", (String)"xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\"");
        String result = StringUtils.replace((String)temp, (String)"stylecop:Project", (String)"Project");
        PrintWriter outputWriter = new PrintWriter(stream);
        outputWriter.print(result);
        outputWriter.flush();
    }

    private String toWindowsPath(File file) {
        return file.toString();
    }

    public File getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(File projectRoot) {
        this.projectRoot = projectRoot;
    }

    public File getStyleCopRoot() {
        return this.styleCopRoot;
    }

    public void setStyleCopRoot(File styleCopRoot) {
        this.styleCopRoot = styleCopRoot;
    }

    public File getVisualSolution() {
        return this.visualSolution;
    }

    public void setVisualSolution(File visualSolution) {
        this.visualSolution = visualSolution;
    }

    public List<File> getVisualProjects() {
        return this.visualProjects;
    }

    public void addVisualProject(File visualProject) {
        this.visualProjects.add(visualProject);
    }

    public void setVisualProjects(List<File> visualProjects) {
        this.visualProjects = visualProjects;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public File getSettings() {
        return this.settings;
    }

    public void setSettings(File settings) {
        this.settings = settings;
    }
}

