/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.cobol.ebcdic;

import com.sonarsource.cobol.ebcdic.EbcdicToAsciiConverterException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;

public class FileConverter {
    private static final int INITIAL_BUFFER_SIZE = 2048;
    private static final int LF = 10;
    private static final int NEL = 21;
    private static final int WS = 32;
    static final Charset CP1047 = Charset.forName("Cp1047");
    private static final char[] NON_PRINTABLE_EBCDIC_CHARS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\u0085', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0'};
    private final Charset ebcdicCharset;
    private final Charset outputCharset;
    private int fixedLength = -1;

    public FileConverter(Charset ebcdicCharset, Charset outputCharset) {
        this.ebcdicCharset = ebcdicCharset;
        this.outputCharset = outputCharset;
    }

    public void setFixedLength(int numberOfColumn) {
        this.fixedLength = numberOfColumn;
    }

    void convert(File ebcdicInputFile, File convertedOutputFile) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ebcdicInputFile), this.ebcdicCharset));
            int[] ebcdicInput = this.loadContent(reader);
            this.close(reader);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(convertedOutputFile), this.outputCharset));
            this.convert(ebcdicInput, (Writer)writer);
            this.close(writer);
        }
        catch (Exception e) {
            try {
                throw new EbcdicToAsciiConverterException("Unable to convert file " + ebcdicInputFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                this.close(writer);
                throw throwable;
            }
        }
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            throw new EbcdicToAsciiConverterException("Unable to close", e);
        }
    }

    void convert(String input, Writer convertedOutputWriter) throws IOException {
        this.convert(this.loadContent(new StringReader(input)), convertedOutputWriter);
    }

    private void convert(int[] ebcdicInput, Writer convertedOutputWriter) throws IOException {
        for (int index = 0; index < ebcdicInput.length; ++index) {
            int character = ebcdicInput[index];
            if (this.fixedLength != -1 && index > 0 && index % this.fixedLength == 0) {
                convertedOutputWriter.append('\n');
            }
            int convertedChar = this.fixedLength == -1 && character == 21 ? 10 : this.replaceNonPrintableCharacterByWhitespace(character);
            convertedOutputWriter.append((char)convertedChar);
        }
    }

    private int replaceNonPrintableCharacterByWhitespace(int character) {
        for (char nonPrintableChar : NON_PRINTABLE_EBCDIC_CHARS) {
            if (nonPrintableChar != (char)character) continue;
            return 32;
        }
        return character;
    }

    private int[] loadContent(Reader reader) throws IOException {
        int character;
        int[] buffer = new int[2048];
        int bufferIndex = 0;
        int bufferSize = buffer.length;
        while ((character = reader.read()) != -1) {
            if (bufferIndex == bufferSize) {
                buffer = this.resizeArray(buffer, bufferSize + 2048);
                bufferSize = buffer.length;
            }
            buffer[bufferIndex++] = character;
        }
        return this.resizeArray(buffer, bufferIndex);
    }

    final int[] resizeArray(int[] orignalArray, int newSize) {
        int[] resizedArray = new int[newSize];
        for (int i = 0; i < newSize && i < orignalArray.length; ++i) {
            resizedArray[i] = orignalArray[i];
        }
        return resizedArray;
    }
}

