/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.ChapterAutoNumber;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.report.pdf.PDFReporter;
import org.sonar.report.pdf.Style;
import org.sonar.report.pdf.Toc;
import org.sonar.report.pdf.entity.Measures;
import org.sonar.report.pdf.entity.Project;
import org.sonar.report.pdf.entity.exception.ReportException;
import org.sonar.report.pdf.util.Credentials;

public class DefaultPDFReporter
extends PDFReporter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPDFReporter.class);
    private static final String REPORT_TYPE_WORKBOOK = "workbook";
    private URL logo;
    private String projectKey;
    private Properties configProperties;
    private Properties langProperties;
    private static final int indentation = 18;
    private static final int tablePaddingBottom = 5;
    private Document document;

    public DefaultPDFReporter(Credentials credentials, URL logo, String projectKey, Properties configProperties, Properties langProperties) {
        super(credentials);
        this.logo = logo;
        this.projectKey = projectKey;
        this.configProperties = configProperties;
        this.langProperties = langProperties;
    }

    @Override
    protected void printPdfBody(Document document) throws DocumentException, IOException, ReportException {
        this.document = document;
        ChapterAutoNumber chapter1 = new ChapterAutoNumber(new Paragraph(this.getTextProperty("main.chapter1.title"), Style.CHAPTER_FONT));
        chapter1.add((Object)new Paragraph(this.getTextProperty("main.chapter1.intro"), Style.NORMAL_FONT));
        Section section11 = chapter1.addSection(new Paragraph(this.getTextProperty("main.chapter1.subtitle1"), Style.TITLE_FONT));
        Project project = super.getProject();
        this.printDashboard(project, section11);
        Section section12 = chapter1.addSection(new Paragraph(this.getTextProperty("main.chapter1.subtitle2"), Style.TITLE_FONT));
        this.printProjectInfo(project, section12);
        document.add((Element)chapter1);
        for (Project subproject : project.getSubprojects()) {
            ChapterAutoNumber subprojectChapter = new ChapterAutoNumber(new Paragraph(this.getTextProperty("general.module") + ": " + subproject.getName(), Style.TITLE_FONT));
            Section sectionX1 = subprojectChapter.addSection(new Paragraph(this.getTextProperty("main.chapter2.subtitle2X1"), Style.TITLE_FONT));
            this.printDashboard(subproject, sectionX1);
            Section sectionX2 = subprojectChapter.addSection(new Paragraph(this.getTextProperty("main.chapter2.subtitle2X2"), Style.TITLE_FONT));
            this.printProjectInfo(subproject, sectionX2);
            document.add((Element)subprojectChapter);
        }
    }

    private void printDashboard(Project project, Section section) throws DocumentException {
        PdfPTable dashboard = new PdfPTable(3);
        dashboard.getDefaultCell().setBorderColor(Color.WHITE);
        Font titleFont = new Font(2, 14.0f, 1, Color.BLACK);
        Font dataFont = new Font(2, 14.0f, 1, Color.GRAY);
        Font dataFont2 = new Font(2, 10.0f, 1, new Color(100, 150, 190));
        PdfPTable linesOfCode = new PdfPTable(1);
        linesOfCode.getDefaultCell().setBorderColor(Color.WHITE);
        linesOfCode.addCell(new Phrase(this.getTextProperty("general.lines_of_code"), titleFont));
        linesOfCode.addCell(new Phrase(project.getMeasure("ncss").getFormatValue(), dataFont));
        linesOfCode.addCell(new Phrase(project.getMeasure("packages_count").getFormatValue() + " packages", dataFont2));
        linesOfCode.addCell(new Phrase(project.getMeasure("classes_count").getFormatValue() + " classes", dataFont2));
        linesOfCode.addCell(new Phrase(project.getMeasure("functions_count").getFormatValue() + " methods", dataFont2));
        linesOfCode.addCell(new Phrase(project.getMeasure("duplicated_lines_ratio").getFormatValue() + " duplicated lines", dataFont2));
        PdfPTable comments = new PdfPTable(1);
        comments.getDefaultCell().setBorderColor(Color.WHITE);
        comments.addCell(new Phrase(this.getTextProperty("general.comments"), titleFont));
        comments.addCell(new Phrase(project.getMeasure("comment_ratio").getFormatValue(), dataFont));
        comments.addCell(new Phrase(project.getMeasure("comment_lines").getFormatValue() + " comment lines", dataFont2));
        PdfPTable codeCoverage = new PdfPTable(1);
        codeCoverage.getDefaultCell().setBorderColor(Color.WHITE);
        codeCoverage.addCell(new Phrase(this.getTextProperty("general.test_count"), titleFont));
        codeCoverage.addCell(new Phrase(project.getMeasure("test_count").getFormatValue(), dataFont));
        codeCoverage.addCell(new Phrase(project.getMeasure("test_success_percentage").getFormatValue() + " success", dataFont2));
        codeCoverage.addCell(new Phrase(project.getMeasure("code_coverage").getFormatValue() + " coverage", dataFont2));
        PdfPTable complexity = new PdfPTable(1);
        complexity.getDefaultCell().setBorderColor(Color.WHITE);
        complexity.addCell(new Phrase(this.getTextProperty("general.complexity"), titleFont));
        complexity.addCell(new Phrase(project.getMeasure("ccn_function").getFormatValue(), dataFont));
        complexity.addCell(new Phrase(project.getMeasure("ccn_class").getFormatValue() + " /class", dataFont2));
        complexity.addCell(new Phrase(project.getMeasure("ccn").getFormatValue() + " decision points", dataFont2));
        PdfPTable rulesCompliance = new PdfPTable(1);
        rulesCompliance.getDefaultCell().setBorderColor(Color.WHITE);
        rulesCompliance.addCell(new Phrase(this.getTextProperty("general.rules_compliance"), titleFont));
        rulesCompliance.addCell(new Phrase(project.getMeasure("rules_compliance").getFormatValue(), dataFont));
        PdfPTable violations = new PdfPTable(1);
        violations.getDefaultCell().setBorderColor(Color.WHITE);
        violations.addCell(new Phrase(this.getTextProperty("general.violations"), titleFont));
        violations.addCell(new Phrase(project.getMeasure("rules_violations").getFormatValue(), dataFont));
        dashboard.addCell(linesOfCode);
        dashboard.addCell(comments);
        dashboard.addCell(codeCoverage);
        dashboard.addCell(complexity);
        dashboard.addCell(rulesCompliance);
        dashboard.addCell(violations);
        dashboard.setSpacingBefore(8.0f);
        section.add((Object)dashboard);
        Image ccnDistGraph = this.getCCNDistribution(project);
        if (ccnDistGraph != null) {
            section.add((Object)ccnDistGraph);
            Paragraph imageFoot = new Paragraph(this.getTextProperty("metrics.ccn_classes_count_distribution"), Style.FOOT_FONT);
            imageFoot.setAlignment(1);
            section.add((Object)imageFoot);
        }
    }

    private void printMeasures(Measures measures, Section section) {
        PdfPTable versioningTable = new PdfPTable(2);
        this.formatTable(versioningTable);
        versioningTable.getDefaultCell().setColspan(2);
        versioningTable.addCell(new Phrase(super.getTextProperty("general.versioning_information"), Style.TITLE_FONT));
        versioningTable.addCell(measures.getVersion());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss");
        versioningTable.addCell(df.format(measures.getDate()));
        PdfPTable measuresTable = new PdfPTable(2);
        this.formatTable(measuresTable);
        Iterator<String> it = measures.getMeasuresKeys().iterator();
        measuresTable.addCell(new Phrase(super.getTextProperty("general.metric"), Style.TITLE_FONT));
        measuresTable.addCell(new Phrase(super.getTextProperty("general.value"), Style.TITLE_FONT));
        boolean colorEnabled = true;
        while (it.hasNext()) {
            String measureKey = it.next();
            if (colorEnabled) {
                measuresTable.getDefaultCell().setGrayFill(0.9f);
                colorEnabled = false;
            } else {
                measuresTable.getDefaultCell().setGrayFill(1.0f);
                colorEnabled = true;
            }
            if (measureKey.equals("ccn_classes_count_distribution") || measureKey.equals("ccn_classes_percent_distribution")) continue;
            measuresTable.getDefaultCell().setHorizontalAlignment(0);
            measuresTable.addCell(super.getTextProperty("metrics." + measureKey));
            measuresTable.getDefaultCell().setHorizontalAlignment(1);
            measuresTable.addCell(measures.getMeasure(measureKey).getFormatValue());
        }
        measuresTable.setHeaderRows(1);
        section.add((Object)versioningTable);
        section.add((Object)measuresTable);
    }

    private void formatTable(PdfPTable table) {
        Rectangle page = this.document.getPageSize();
        table.getDefaultCell().setVerticalAlignment(5);
        table.getDefaultCell().setPaddingBottom(5.0f);
        table.getDefaultCell().setHorizontalAlignment(1);
        table.setTotalWidth(page.getWidth() - this.document.leftMargin() - this.document.rightMargin());
        table.setSpacingBefore(20.0f);
    }

    private void printProjectInfo(Project project, Section section) throws DocumentException {
        List data = new List();
        data.add((Object)new ListItem(super.getTextProperty("general.name") + ": " + project.getName()));
        data.add((Object)new ListItem(super.getTextProperty("general.description") + ": " + project.getDescription()));
        data.add((Object)new ListItem(super.getTextProperty("general.modules") + ": "));
        List sublist = new List();
        if (project.getSubprojects().size() != 0) {
            Iterator<Project> it = project.getSubprojects().iterator();
            while (it.hasNext()) {
                sublist.add((Object)new ListItem(it.next().getName()));
            }
        } else {
            sublist.add((Object)new ListItem(super.getTextProperty("general.no_modules")));
        }
        sublist.setIndentationLeft(18.0f);
        data.add((Object)sublist);
        section.add((Object)data);
        this.printMeasures(project.getMeasures(), section);
    }

    @Override
    protected URL getLogo() {
        return this.logo;
    }

    @Override
    protected String getProjectKey() {
        return this.projectKey;
    }

    @Override
    protected void printTocTitle(Toc tocDocument) throws DocumentException {
        Paragraph tocTitle = new Paragraph(super.getTextProperty("main.table.of.contents"), Style.TOC_TITLE_FONT);
        tocTitle.setAlignment(1);
        tocDocument.getTocDocument().add((Element)tocTitle);
        tocDocument.getTocDocument().add((Element)Chunk.NEWLINE);
    }

    @Override
    protected void printFrontPage(Document frontPageDocument, PdfWriter frontPageWriter) throws ReportException {
        try {
            URL largeLogo = super.getConfigProperty("front.page.logo").startsWith("http://") ? new URL(super.getConfigProperty("front.page.logo")) : this.getClass().getClassLoader().getResource(super.getConfigProperty("front.page.logo"));
            Image logoImage = Image.getInstance((URL)largeLogo);
            Rectangle pageSize = frontPageDocument.getPageSize();
            float positionX = pageSize.getWidth() / 2.0f - logoImage.getWidth() / 2.0f;
            logoImage.setAbsolutePosition(positionX, pageSize.getHeight() - logoImage.getHeight() - 100.0f);
            frontPageDocument.add((Element)logoImage);
            PdfPTable title = new PdfPTable(1);
            title.getDefaultCell().setHorizontalAlignment(1);
            title.getDefaultCell().setBorder(0);
            String projectRow = super.getTextProperty("general.project") + ": " + super.getProject().getName();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String dateRow = df.format(super.getProject().getMeasures().getDate());
            String descriptionRow = super.getProject().getDescription();
            title.addCell(new Phrase(projectRow, Style.FRONTPAGE_FONT_1));
            title.addCell(new Phrase(descriptionRow, Style.FRONTPAGE_FONT_2));
            title.addCell(new Phrase(dateRow, Style.FRONTPAGE_FONT_3));
            title.setTotalWidth(pageSize.getWidth() - frontPageDocument.leftMargin() - frontPageDocument.rightMargin());
            title.writeSelectedRows(0, -1, frontPageDocument.leftMargin(), pageSize.getHeight() - logoImage.getHeight() - 150.0f, frontPageWriter.getDirectContent());
        }
        catch (IOException e) {
            LOG.error("Can not generate front page", (Throwable)e);
        }
        catch (BadElementException e) {
            LOG.error("Can not generate front page", (Throwable)e);
        }
        catch (DocumentException e) {
            LOG.error("Can not generate front page", (Throwable)e);
        }
    }

    @Override
    protected Properties getLangProperties() {
        return this.langProperties;
    }

    @Override
    protected Properties getReportProperties() {
        return this.configProperties;
    }

    @Override
    public String getReportType() {
        return REPORT_TYPE_WORKBOOK;
    }
}

