/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.builder;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.report.pdf.entity.Rule;
import org.sonar.report.pdf.entity.Violation;
import org.sonar.report.pdf.entity.exception.ReportException;
import org.sonar.report.pdf.util.Credentials;
import org.sonar.wsclient.Sonar;
import org.sonar.wsclient.SonarClient;
import org.sonar.wsclient.issue.Issue;
import org.sonar.wsclient.issue.IssueClient;
import org.sonar.wsclient.issue.IssueQuery;
import org.sonar.wsclient.issue.Issues;
import org.sonar.wsclient.services.Measure;

public class RuleBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RuleBuilder.class);
    private static RuleBuilder builder;
    private Credentials credentials;

    public RuleBuilder(Credentials credentials) {
        this.credentials = credentials;
    }

    public static RuleBuilder getInstance(Credentials credentials, Sonar sonar) {
        if (builder == null) {
            return new RuleBuilder(credentials);
        }
        return builder;
    }

    public Rule initFromNode(Measure ruleNode) {
        Rule rule = new Rule();
        rule.setKey(ruleNode.getRuleKey());
        rule.setName(ruleNode.getRuleName());
        rule.setViolationsNumber(ruleNode.getValue());
        rule.setViolationsNumberFormatted(ruleNode.getFormattedValue());
        return rule;
    }

    public void loadViolatedResources(Rule rule, String ruleKey, String projectKey) throws ReportException, UnsupportedEncodingException {
        if (ruleKey == null) {
            throw new ReportException("Rule not initialized. Forget call to initFromNode() previously?");
        }
        LOG.debug("Accessing Sonar: getting violated resurces by one given rule (" + ruleKey + ")");
        SonarClient client = SonarClient.create(this.credentials.getUrl());
        IssueClient issueClient = client.issueClient();
        IssueQuery issueQuery = IssueQuery.create();
        issueQuery.componentRoots(projectKey);
        issueQuery.pageSize(20);
        issueQuery.rules(ruleKey);
        Issues issues = issueClient.find(issueQuery);
        List<Issue> violatedResources = issues.list();
        LinkedList<Violation> topViolatedResources = new LinkedList<Violation>();
        rule.setTopViolatedResources(topViolatedResources);
        for (Issue resource : violatedResources) {
            if (rule.getMessage() == null) {
                rule.setMessage(resource.message());
            }
            String resourceKey = resource.componentKey();
            String line = "N/A";
            Integer resourceLine = resource.line();
            if (resourceLine != null) {
                line = String.valueOf(resourceLine);
            }
            topViolatedResources.add(new Violation(line, resourceKey, ""));
        }
    }
}

