/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Metric;
import org.sonar.wsclient.services.UpdateQuery;

public class MetricUpdateQuery
extends UpdateQuery<Metric> {
    private String key;
    private String name;
    private String description;
    private String domain;
    private String type;

    public static MetricUpdateQuery update(String key) {
        return new MetricUpdateQuery(key);
    }

    private MetricUpdateQuery(String key) {
        this.key = key;
    }

    public MetricUpdateQuery setName(String name) {
        this.name = name;
        return this;
    }

    public MetricUpdateQuery setDescription(String description) {
        this.description = description;
        return this;
    }

    public MetricUpdateQuery setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public MetricUpdateQuery setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder();
        url.append("/api/metrics");
        url.append("/").append(MetricUpdateQuery.encode(this.key));
        url.append('?');
        MetricUpdateQuery.appendUrlParameter(url, "name", this.name);
        MetricUpdateQuery.appendUrlParameter(url, "description", this.description);
        MetricUpdateQuery.appendUrlParameter(url, "domain", this.domain);
        MetricUpdateQuery.appendUrlParameter(url, "val_type", this.type);
        return url.toString();
    }

    @Override
    public String getBody() {
        return this.description;
    }

    @Override
    public Class<Metric> getModelClass() {
        return Metric.class;
    }
}

