/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pitest;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.pitest.Mutant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFileMutants {
    private List<Mutant> mutants = new ArrayList<Mutant>();
    private double mutationsTotal = 0.0;
    private double mutationsNoCoverage = 0.0;
    private double mutationsKilled = 0.0;
    private double mutationsSurvived = 0.0;
    private double mutationsMemoryError = 0.0;
    private double mutationsTimedOut = 0.0;
    private double mutationsUnknown = 0.0;
    private double mutationsDetected = 0.0;

    void addMutant(Mutant mutant) {
        this.mutants.add(mutant);
        if (mutant.isDetected()) {
            this.incMutationsDetected();
        }
        switch (mutant.getMutantStatus()) {
            case KILLED: {
                this.incMutationsKilled();
                break;
            }
            case NO_COVERAGE: {
                this.incMutationsNoCoverage();
                break;
            }
            case SURVIVED: {
                this.incMutationsSurvived();
                break;
            }
            case MEMORY_ERROR: {
                this.incMutationsMemoryError();
                break;
            }
            case TIMED_OUT: {
                this.incMutationsTimedOut();
                break;
            }
            case UNKNOWN: {
                this.incMutationsUnknown();
            }
        }
    }

    private void incMutationsTotal() {
        this.mutationsTotal += 1.0;
    }

    private void incMutationsNoCoverage() {
        this.incMutationsTotal();
        this.mutationsNoCoverage += 1.0;
    }

    private void incMutationsKilled() {
        this.incMutationsTotal();
        this.mutationsKilled += 1.0;
    }

    private void incMutationsSurvived() {
        this.incMutationsTotal();
        this.mutationsSurvived += 1.0;
    }

    private void incMutationsMemoryError() {
        this.incMutationsTotal();
        this.mutationsMemoryError += 1.0;
    }

    private void incMutationsTimedOut() {
        this.incMutationsTotal();
        this.mutationsTimedOut += 1.0;
    }

    private void incMutationsUnknown() {
        this.incMutationsTotal();
        this.mutationsUnknown += 1.0;
    }

    private void incMutationsDetected() {
        this.mutationsDetected += 1.0;
    }

    List<Mutant> getMutants() {
        return this.mutants;
    }

    double getMutationsTotal() {
        return this.mutationsTotal;
    }

    double getMutationsNoCoverage() {
        return this.mutationsNoCoverage;
    }

    double getMutationsKilled() {
        return this.mutationsKilled;
    }

    double getMutationsSurvived() {
        return this.mutationsSurvived;
    }

    double getMutationsMemoryError() {
        return this.mutationsMemoryError;
    }

    double getMutationsTimedOut() {
        return this.mutationsTimedOut;
    }

    double getMutationsUnknown() {
        return this.mutationsUnknown;
    }

    double getMutationsDetected() {
        return this.mutationsDetected;
    }
}

