/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pitest;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import java.util.Iterator;
import java.util.List;
import org.sonar.plugins.pitest.MutantStatus;
import org.sonar.plugins.pitest.Mutator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mutant {
    private final boolean detected;
    private final MutantStatus mutantStatus;
    private final String className;
    private final int lineNumber;
    private final Mutator mutator;
    private transient String sonarJavaFileKey;

    public Mutant(boolean detected, MutantStatus mutantStatus, String className, int lineNumber, String mutatorKey) {
        this(detected, mutantStatus, className, lineNumber, Mutator.parse(mutatorKey));
    }

    private Mutant(boolean detected, MutantStatus mutantStatus, String className, int lineNumber, Mutator mutator) {
        this.detected = detected;
        this.mutantStatus = mutantStatus;
        this.className = className;
        this.lineNumber = lineNumber;
        this.mutator = mutator;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public MutantStatus getMutantStatus() {
        return this.mutantStatus;
    }

    public String getSonarJavaFileKey() {
        if (this.sonarJavaFileKey == null) {
            this.sonarJavaFileKey = this.className.indexOf(36) > -1 ? this.className.substring(0, this.className.indexOf(36)) : this.className;
        }
        return this.sonarJavaFileKey;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getViolationDescription() {
        return this.mutator.getDescription() + " without breaking the tests";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.className, this.detected, this.lineNumber, this.mutantStatus, this.mutator});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mutant other = (Mutant)obj;
        return Objects.equal((Object)this.className, (Object)other.className) && Objects.equal((Object)this.detected, (Object)other.detected) && Objects.equal((Object)this.lineNumber, (Object)other.lineNumber) && Objects.equal((Object)((Object)this.mutantStatus), (Object)((Object)other.mutantStatus)) && Objects.equal((Object)((Object)this.mutator), (Object)((Object)other.mutator));
    }

    public String toString() {
        return this.toJSON();
    }

    public static String toJSON(List<Mutant> mutants) {
        ArrayListMultimap mutantsByLine = ArrayListMultimap.create();
        for (Mutant mutant : mutants) {
            mutantsByLine.put((Object)mutant.getLineNumber(), (Object)mutant.toJSON());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean first = true;
        Iterator i$ = mutantsByLine.keySet().iterator();
        while (i$.hasNext()) {
            int line = (Integer)i$.next();
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append("\"");
            builder.append(line);
            builder.append("\":[");
            builder.append(Joiner.on((String)",").join((Iterable)mutantsByLine.get((Object)line)));
            builder.append("]");
        }
        builder.append("}");
        return builder.toString();
    }

    private String toJSON() {
        return "{ \"d\" : " + this.detected + ", \"s\" : \"" + (Object)((Object)this.mutantStatus) + "\", \"c\" : \"" + this.className + "\", \"mname\" : \"" + this.mutator.getName() + "\", \"mdesc\" : \"" + this.mutator.getDescription() + "\"  }";
    }
}

