/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pitest;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.pitest.PitestMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PitestCoverageDecorator
implements Decorator {
    public boolean shouldExecuteOnProject(Project project) {
        return project.getAnalysisType().isDynamic(true);
    }

    @DependedUpon
    public Metric getCoverageMetric() {
        return PitestMetrics.MUTATIONS_COVERAGE;
    }

    @DependsUpon
    public List<Metric> getBaseMetrics() {
        return Lists.newArrayList((Object[])new Metric[]{PitestMetrics.MUTATIONS_DETECTED, PitestMetrics.MUTATIONS_TOTAL});
    }

    public void decorate(Resource resource, DecoratorContext context) {
        Double elements = MeasureUtils.getValue((Measure)context.getMeasure(PitestMetrics.MUTATIONS_TOTAL), (Double)0.0);
        if (elements > 0.0) {
            Double coveredElements = MeasureUtils.getValue((Measure)context.getMeasure(PitestMetrics.MUTATIONS_DETECTED), (Double)0.0);
            context.saveMeasure(PitestMetrics.MUTATIONS_COVERAGE, Double.valueOf(100.0 * coveredElements / elements));
        }
    }
}

