/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pitest;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PitestMetrics
implements Metrics {
    private static final List<Metric> METRICS = new ArrayList<Metric>();
    private static final List<Metric> QUANTITATIVE_METRICS = new ArrayList<Metric>();
    public static final String PITEST_DOMAIN = "Mutation analysis";
    public static final Metric MUTATIONS_DATA = PitestMetrics.buildMetric("pitest_mutations_data", "Mutations Data", "Data of mutations", Metric.ValueType.DATA, 0, true, "Mutation analysis");
    public static final Metric MUTATIONS_TOTAL = PitestMetrics.buildMetric("pitest_mutations_total", "Total Mutations", "Total number of mutations generated", Metric.ValueType.INT, 1, false, "Mutation analysis");
    public static final Metric MUTATIONS_DETECTED = PitestMetrics.buildMetric("pitest_mutations_detected", "Detected Mutations", "Total number of mutations detected", Metric.ValueType.INT, 1, false, "Mutation analysis");
    public static final Metric MUTATIONS_NO_COVERAGE = PitestMetrics.buildMetric("pitest_mutations_noCoverage", "Non Covered Mutations", "Number of mutations non covered by any test.", Metric.ValueType.INT, -1, false, "Mutation analysis");
    public static final Metric MUTATIONS_KILLED = PitestMetrics.buildMetric("pitest_mutations_killed", "Killed Mutations", "Number of mutations killed by tests", Metric.ValueType.INT, 1, false, "Mutation analysis");
    public static final Metric MUTATIONS_SURVIVED = PitestMetrics.buildMetric("pitest_mutations_survived", "Survived Mutations", "Number of mutations survived.", Metric.ValueType.INT, -1, false, "Mutation analysis");
    public static final Metric MUTATIONS_MEMORY_ERROR = PitestMetrics.buildMetric("pitest_mutations_memoryError", "Memory Error Mutations", "Number of mutations detected by memory errors.", Metric.ValueType.INT, 1, false, "Mutation analysis");
    public static final Metric MUTATIONS_TIMED_OUT = PitestMetrics.buildMetric("pitest_mutations_timedOut", "Timed Out Mutations", "Number of mutations detected by time outs.", Metric.ValueType.INT, 1, false, "Mutation analysis");
    public static final Metric MUTATIONS_UNKNOWN = PitestMetrics.buildMetric("pitest_mutations_unknown", "Unknown Status Mutations", "Number of mutations with unknown status.", Metric.ValueType.INT, -1, false, "Mutation analysis");
    public static final Metric MUTATIONS_COVERAGE = PitestMetrics.buildMetric("pitest_mutations_coverage", "Mutations Coverage", "Mutations coverage percentage", Metric.ValueType.PERCENT, 1, true, "Mutation analysis", 100.0, 0.0);

    private static Metric buildMetric(String key, String name, String description, Metric.ValueType valueType, Integer direction, Boolean qualitative, String domain) {
        return PitestMetrics.buildMetric(PitestMetrics.instanceBuilder(key, name, description, valueType, direction, qualitative, domain), qualitative);
    }

    private static Metric buildMetric(String key, String name, String description, Metric.ValueType valueType, Integer direction, Boolean qualitative, String domain, Double best, Double worst) {
        Metric.Builder builder = PitestMetrics.instanceBuilder(key, name, description, valueType, direction, qualitative, domain);
        builder.setBestValue(best);
        builder.setWorstValue(worst);
        return PitestMetrics.buildMetric(builder, qualitative);
    }

    private static Metric buildMetric(Metric.Builder builder, boolean qualitative) {
        Metric metric = builder.create();
        METRICS.add(metric);
        if (!qualitative) {
            QUANTITATIVE_METRICS.add(metric);
        }
        return metric;
    }

    private static Metric.Builder instanceBuilder(String key, String name, String description, Metric.ValueType valueType, Integer direction, Boolean quailitative, String domain) {
        Metric.Builder builder = new Metric.Builder(key, name, valueType);
        builder.setDescription(description);
        builder.setDirection(direction);
        builder.setQualitative(quailitative);
        builder.setDomain(domain);
        return builder;
    }

    public List<Metric> getMetrics() {
        return METRICS;
    }

    public static List<Metric> getQuantitativeMetrics() {
        return QUANTITATIVE_METRICS;
    }
}

