/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pitest;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.measures.Measure;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.plugins.pitest.JavaFileMutants;
import org.sonar.plugins.pitest.Mutant;
import org.sonar.plugins.pitest.MutantStatus;
import org.sonar.plugins.pitest.PitestMetrics;
import org.sonar.plugins.pitest.ReportFinder;
import org.sonar.plugins.pitest.ResultParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PitestSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(PitestSensor.class);
    private JavaFileMutants noResourceMetrics = new JavaFileMutants();
    private final Configuration configuration;
    private final ResultParser parser;
    private final ReportFinder reportFinder;
    private final String executionMode;
    private final RulesProfile rulesProfile;
    private final ModuleFileSystem fileSystem;
    private final ResourcePerspectives perspectives;

    public PitestSensor(Configuration configuration, ResultParser parser, RulesProfile rulesProfile, ReportFinder reportFinder, ModuleFileSystem fileSystem, ResourcePerspectives perspectives) {
        this.configuration = configuration;
        this.parser = parser;
        this.reportFinder = reportFinder;
        this.fileSystem = fileSystem;
        this.perspectives = perspectives;
        this.executionMode = configuration.getString("sonar.pitest.mode", "skip");
        this.rulesProfile = rulesProfile;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.getAnalysisType().isDynamic(true) && !this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"java"})).isEmpty() && !"skip".equals(this.executionMode);
    }

    public void analyse(Project project, SensorContext context) {
        String reportDirectoryPath;
        File projectDirectory;
        File reportDirectory;
        File xmlReport;
        List activeRules = this.rulesProfile.getActiveRulesByRepository("pitest");
        if (activeRules.isEmpty()) {
            LOG.warn("/!\\ PIT rule needs to be activated in the \"{}\" profile.", (Object)this.rulesProfile.getName());
            LOG.warn("Checkout plugin documentation for more detailed explanations: http://docs.codehaus.org/display/SONAR/Pitest");
        }
        if ((xmlReport = this.reportFinder.findReport(reportDirectory = new File(projectDirectory = this.fileSystem.baseDir(), reportDirectoryPath = this.configuration.getString("sonar.pitest.reportsDirectory", "target/pit-reports")))) == null) {
            LOG.warn("No XML PIT report found in directory {} !", (Object)reportDirectory);
            LOG.warn("Checkout plugin documentation for more detailed explanations: http://docs.codehaus.org/display/SONAR/Pitest");
        } else {
            Collection<Mutant> mutants = this.parser.parse(xmlReport);
            this.saveMutantsInfo(mutants, context, activeRules);
        }
    }

    private void saveMutantsInfo(Collection<Mutant> mutants, SensorContext context, List<ActiveRule> activeRules) {
        Map<Resource<?>, JavaFileMutants> metrics = this.collectMetrics(mutants, context, activeRules);
        for (Map.Entry<Resource<?>, JavaFileMutants> entry : metrics.entrySet()) {
            this.saveMetricsInfo(context, entry.getKey(), entry.getValue());
        }
    }

    private void saveMetricsInfo(SensorContext context, Resource<?> resource, JavaFileMutants metricsInfo) {
        double detected = metricsInfo.getMutationsDetected();
        double total = metricsInfo.getMutationsTotal();
        context.saveMeasure(resource, PitestMetrics.MUTATIONS_TOTAL, Double.valueOf(total));
        context.saveMeasure(resource, PitestMetrics.MUTATIONS_NO_COVERAGE, Double.valueOf(metricsInfo.getMutationsNoCoverage()));
        context.saveMeasure(resource, PitestMetrics.MUTATIONS_KILLED, Double.valueOf(metricsInfo.getMutationsKilled()));
        context.saveMeasure(resource, PitestMetrics.MUTATIONS_SURVIVED, Double.valueOf(metricsInfo.getMutationsSurvived()));
        context.saveMeasure(resource, PitestMetrics.MUTATIONS_MEMORY_ERROR, Double.valueOf(metricsInfo.getMutationsMemoryError()));
        context.saveMeasure(resource, PitestMetrics.MUTATIONS_TIMED_OUT, Double.valueOf(metricsInfo.getMutationsTimedOut()));
        context.saveMeasure(resource, PitestMetrics.MUTATIONS_UNKNOWN, Double.valueOf(metricsInfo.getMutationsUnknown()));
        context.saveMeasure(resource, PitestMetrics.MUTATIONS_DETECTED, Double.valueOf(detected));
        this.saveData(context, resource, metricsInfo.getMutants());
    }

    private void saveData(SensorContext context, Resource<?> resource, List<Mutant> mutants) {
        if (mutants != null && !mutants.isEmpty()) {
            String json = Mutant.toJSON(mutants);
            Measure measure = new Measure(PitestMetrics.MUTATIONS_DATA, json);
            context.saveMeasure(resource, measure);
        }
    }

    private Map<Resource<?>, JavaFileMutants> collectMetrics(Collection<Mutant> mutants, SensorContext context, List<ActiveRule> activeRules) {
        HashMap metricsByResource = new HashMap();
        Rule rule = this.getSurvivedRule(activeRules);
        for (Mutant mutant : mutants) {
            JavaFile file = new JavaFile(mutant.getSonarJavaFileKey());
            Resource resource = context.getResource((Resource)file);
            if (resource == null) {
                LOG.warn("Mutation in an unknown resource: {}", (Object)mutant.getSonarJavaFileKey());
                LOG.debug("Mutant: {}", (Object)mutant);
                this.processMutant(mutant, this.noResourceMetrics, resource, context, rule);
                continue;
            }
            this.processMutant(mutant, PitestSensor.getMetricsInfo(metricsByResource, resource), resource, context, rule);
        }
        return metricsByResource;
    }

    private Rule getSurvivedRule(List<ActiveRule> activeRules) {
        Rule rule = null;
        if (activeRules != null && !activeRules.isEmpty()) {
            rule = activeRules.get(0).getRule();
        }
        return rule;
    }

    private void processMutant(Mutant mutant, JavaFileMutants resourceMetricsInfo, Resource resource, SensorContext context, Rule rule) {
        Issuable issuable;
        resourceMetricsInfo.addMutant(mutant);
        if (resource != null && rule != null && MutantStatus.SURVIVED.equals((Object)mutant.getMutantStatus()) && (issuable = (Issuable)this.perspectives.as(Issuable.class, resource)) != null) {
            Issue issue = issuable.newIssueBuilder().ruleKey(RuleKey.of((String)"pitest", (String)"pitest.survived.mutant")).line(Integer.valueOf(mutant.getLineNumber())).message(mutant.getViolationDescription()).build();
            issuable.addIssue(issue);
        }
    }

    private static JavaFileMutants getMetricsInfo(Map<Resource<?>, JavaFileMutants> metrics, Resource<?> resource) {
        JavaFileMutants metricsInfo = null;
        if (resource != null && (metricsInfo = metrics.get(resource)) == null) {
            metricsInfo = new JavaFileMutants();
            metrics.put(resource, metricsInfo);
        }
        return metricsInfo;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

