/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.pitest;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.pitest.Mutant;
import org.sonar.plugins.pitest.MutantStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultParser
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(ResultParser.class);
    private static final String ATTR_DETECTED = "detected";
    private static final String ATTR_STATUS = "status";
    private static final String ATTR_CLASS = "mutatedClass";
    private static final String ATTR_LINE = "lineNumber";
    private static final String ATTR_MUTATOR = "mutator";

    public Collection<Mutant> parse(File report) {
        ArrayList mutants = Lists.newArrayList();
        SMInputFactory inf = new SMInputFactory(XMLInputFactory.newInstance());
        try {
            SMHierarchicCursor rootCursor = inf.rootElementCursor(report);
            rootCursor.advance();
            SMInputCursor mutationCursor = rootCursor.childElementCursor();
            while (mutationCursor.getNext() != null) {
                boolean detected = Boolean.parseBoolean(mutationCursor.getAttrValue(ATTR_DETECTED));
                String statusName = mutationCursor.getAttrValue(ATTR_STATUS);
                MutantStatus mutantStatus = MutantStatus.parse(statusName);
                if (mutantStatus.equals((Object)MutantStatus.UNKNOWN)) {
                    LOG.warn("Unknown mutation status detected: {}", (Object)statusName);
                }
                String mutatedClass = null;
                String mutator = null;
                int lineNumber = 0;
                SMInputCursor mutationDetailsCursor = mutationCursor.childElementCursor();
                while (mutationDetailsCursor.getNext() != null) {
                    String localPart = mutationDetailsCursor.getQName().getLocalPart();
                    if (ATTR_CLASS.equals(localPart)) {
                        mutatedClass = mutationDetailsCursor.collectDescendantText().trim();
                        continue;
                    }
                    if (ATTR_LINE.equals(localPart)) {
                        lineNumber = Integer.parseInt(mutationDetailsCursor.collectDescendantText().trim());
                        continue;
                    }
                    if (!ATTR_MUTATOR.equals(localPart)) continue;
                    mutator = mutationDetailsCursor.collectDescendantText().trim();
                }
                mutants.add(new Mutant(detected, mutantStatus, mutatedClass, lineNumber, mutator));
            }
        }
        catch (XMLStreamException e) {
            throw new SonarException((Throwable)e);
        }
        return mutants;
    }
}

