/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonrules.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.commonrules.internal.CommonRulesConstants;
import org.sonar.commonrules.internal.DefaultCommonRulesRepository;
import org.sonar.commonrules.internal.checks.CommonCheck;

@DependsUpon(value={"START_VIOLATIONS_GENERATION"})
@DependedUpon(value={"END_OF_VIOLATIONS_GENERATION"})
public abstract class CommonRulesDecorator
implements Decorator {
    private final ProjectFileSystem fs;
    private final String language;
    private final RulesProfile qProfile;
    private AnnotationCheckFactory checkFactory;
    private Collection<CommonCheck> activeChecks = Collections.emptyList();

    public CommonRulesDecorator(String language, ProjectFileSystem fs, RulesProfile qProfile) {
        this.language = language;
        this.fs = fs;
        this.qProfile = qProfile;
    }

    public String language() {
        return this.language;
    }

    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        return Arrays.asList(CoreMetrics.LINE_COVERAGE, CoreMetrics.COMMENT_LINES_DENSITY);
    }

    public boolean shouldExecuteOnProject(Project project) {
        boolean hasLangFiles;
        boolean bl = hasLangFiles = !this.fs.mainFiles(new String[]{this.language}).isEmpty() || !this.fs.testFiles(new String[]{this.language}).isEmpty();
        if (hasLangFiles) {
            this.checkFactory = AnnotationCheckFactory.create((RulesProfile)this.qProfile, (String)DefaultCommonRulesRepository.keyForLanguage(this.language), CommonRulesConstants.CLASSES);
            this.activeChecks = this.checkFactory.getChecks();
        }
        return !this.activeChecks.isEmpty();
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (ResourceUtils.isEntity((Resource)resource) && resource.getLanguage() != null && resource.getLanguage().getKey().equals(this.language)) {
            for (CommonCheck check : this.activeChecks) {
                check.checkResource(resource, context, this.checkFactory.getActiveRule((Object)check).getRule());
            }
        }
    }

    public String toString() {
        return "Common Rules for " + this.language;
    }
}

