/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonrules.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.rules.AnnotationRuleParser;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RuleRepository;
import org.sonar.commonrules.api.CommonRulesRepository;
import org.sonar.commonrules.internal.CommonRulesConstants;

public class DefaultCommonRulesRepository
extends RuleRepository
implements CommonRulesRepository {
    private final Map<String, Rule> supportedRulesByKey;
    private final List<Rule> rules = new ArrayList<Rule>();

    public DefaultCommonRulesRepository(String language) {
        super(DefaultCommonRulesRepository.keyForLanguage(language), language);
        this.setName("Common SonarQube");
        this.supportedRulesByKey = new HashMap<String, Rule>();
        List supportedRules = new AnnotationRuleParser().parse(DefaultCommonRulesRepository.keyForLanguage("common-"), CommonRulesConstants.CLASSES);
        for (Rule supportedRule : supportedRules) {
            this.supportedRulesByKey.put(supportedRule.getKey(), supportedRule);
        }
    }

    public static String keyForLanguage(String language) {
        return "common-" + language;
    }

    @Override
    public DefaultCommonRulesRepository enableInsufficientBranchCoverageRule(@Nullable Double minimumBranchCoverageRatio) {
        this.enableRule("InsufficientBranchCoverage", this.toMap("minimumBranchCoverageRatio", minimumBranchCoverageRatio));
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableInsufficientLineCoverageRule(@Nullable Double minimumLineCoverageRatio) {
        this.enableRule("InsufficientLineCoverage", this.toMap("minimumLineCoverageRatio", minimumLineCoverageRatio));
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableInsufficientCommentDensityRule(@Nullable Double minimumCommentDensity) {
        this.enableRule("InsufficientCommentDensity", this.toMap("minimumCommentDensity", minimumCommentDensity));
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableDuplicatedBlocksRule() {
        this.enableRule("DuplicatedBlocks", Collections.<String, String>emptyMap());
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableSkippedUnitTestsRule() {
        this.enableRule("SkippedUnitTests", Collections.<String, String>emptyMap());
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableFailedUnitTestsRule() {
        this.enableRule("FailedUnitTests", Collections.<String, String>emptyMap());
        return this;
    }

    private Map<String, String> toMap(String key, @Nullable Double value) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (value != null) {
            map.put(key, String.valueOf(value));
        }
        return map;
    }

    DefaultCommonRulesRepository enableRule(String ruleKey, Map<String, String> params) {
        Rule rule = this.supportedRulesByKey.get(ruleKey);
        if (rule == null) {
            throw new IllegalStateException("Unknown rule: " + ruleKey);
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String paramKey = entry.getKey();
            RuleParam param = rule.getParam(paramKey);
            if (param == null) {
                throw new IllegalStateException(String.format("Rule '%s' has no parameter named '%s'", ruleKey, paramKey));
            }
            param.setDefaultValue(entry.getValue());
        }
        this.rules.add(rule);
        return this;
    }

    public List<Rule> createRules() {
        return this.rules();
    }

    @Override
    public List<Rule> rules() {
        return this.rules;
    }

    @Override
    @Nullable
    public Rule rule(String ruleKey) {
        for (Rule rule : this.rules) {
            if (!rule.getKey().equals(ruleKey)) continue;
            return rule;
        }
        return null;
    }
}

