/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.Violation;
import org.sonar.check.Priority;
import org.sonar.check.RuleProperty;
import org.sonar.commonrules.internal.checks.CommonCheck;

@org.sonar.check.Rule(key="InsufficientCommentDensity", name="Insufficient comment density", priority=Priority.MAJOR, description="<p>An issue is created on a file as soon as the comment density coverage on this file is less than the required threshold. It gives the number of comment lines to be written in order to reach the required threshold.</p>")
public class CommentDensityCheck
extends CommonCheck {
    private static final double DEFAULT_MIN_DENSITY = 25.0;
    @RuleProperty(key="minimumCommentDensity", description="The minimum required comment density.", defaultValue="25.0")
    private double minimumCommentDensity = 25.0;

    @Override
    public void checkResource(Resource resource, DecoratorContext context, Rule rule) {
        if (this.minimumCommentDensity < 0.0 || this.minimumCommentDensity >= 100.0) {
            throw new IllegalArgumentException(this.minimumCommentDensity + " is not a valid value for minimum required comment density for rule 'CommentDensityCheck' (must be >= 0 and < 100).");
        }
        double commentDensity = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.COMMENT_LINES_DENSITY), (Double)0.0);
        double linesOfCode = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.NCLOC), (Double)0.0);
        if (commentDensity < this.minimumCommentDensity && linesOfCode != 0.0) {
            double commentLines = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.COMMENT_LINES), (Double)0.0);
            double missingCommentLines = Math.ceil(this.minimumCommentDensity * linesOfCode / (100.0 - this.minimumCommentDensity) - commentLines);
            Violation violation = this.createViolation(resource, rule, missingCommentLines);
            context.saveViolation(violation);
        }
    }

    private Violation createViolation(Resource<?> resource, Rule rule, double missingCommentLines) {
        Violation violation = Violation.create((Rule)rule, resource).setCost(Double.valueOf(missingCommentLines));
        violation.setMessage((int)missingCommentLines + " more comment lines need to be written to reach the minimum threshold of " + this.minimumCommentDensity + "% comment density.");
        return violation;
    }

    public void setMinimumCommentDensity(int threshold) {
        this.minimumCommentDensity = threshold;
    }
}

