/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.Violation;
import org.sonar.check.Priority;
import org.sonar.commonrules.internal.checks.CommonCheck;

@org.sonar.check.Rule(key="DuplicatedBlocks", name="Duplicated blocks", priority=Priority.MAJOR, description="<p>An issue is created on a file as soon as there is a block of duplicated code on this file. It gives the number of blocks in the file.</p>")
public class DuplicatedBlocksCheck
extends CommonCheck {
    @Override
    public void checkResource(Resource resource, DecoratorContext context, Rule rule) {
        double duplicatedBlocks = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.DUPLICATED_BLOCKS), (Double)0.0);
        if (duplicatedBlocks > 0.0) {
            Violation violation = this.createViolation(resource, rule, duplicatedBlocks);
            context.saveViolation(violation);
        }
    }

    private Violation createViolation(Resource resource, Rule rule, double duplicatedBlocks) {
        Violation violation = Violation.create((Rule)rule, (Resource)resource).setCost(Double.valueOf(duplicatedBlocks));
        violation.setMessage((int)duplicatedBlocks + " duplicated blocks of code.");
        return violation;
    }
}

