/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.Violation;
import org.sonar.check.Priority;
import org.sonar.commonrules.internal.checks.CommonCheck;

@org.sonar.check.Rule(key="FailedUnitTests", name="Failed unit tests", priority=Priority.MAJOR, description="<p>Test failures or errors generally indicate that regressions have been introduced. Those tests should be handled as soon as possible to reduce the cost to fix the corresponding regressions.</p>")
public class FailedUnitTestsCheck
extends CommonCheck {
    @Override
    public void checkResource(Resource resource, DecoratorContext context, Rule rule) {
        double testErrors = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.TEST_ERRORS), (Double)0.0);
        double testFailures = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.TEST_FAILURES), (Double)0.0);
        double testFailuresAndErrors = testErrors + testFailures;
        if (ResourceUtils.isUnitTestClass((Resource)resource) && testFailuresAndErrors > 0.0) {
            Violation violation = Violation.create((Rule)rule, (Resource)resource).setCost(Double.valueOf(testFailuresAndErrors));
            violation.setMessage("Some tests are not successful. You should fix them.");
            context.saveViolation(violation);
        }
    }
}

