/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.Violation;
import org.sonar.check.Priority;
import org.sonar.check.RuleProperty;
import org.sonar.commonrules.internal.checks.CommonCheck;

@org.sonar.check.Rule(key="InsufficientLineCoverage", name="Insufficient line coverage by unit tests", priority=Priority.MAJOR, description="<p>An issue is created on a file as soon as the line coverage on this file is less than the required threshold. It gives the number of lines to be covered in order to reach the required threshold.</p>")
public class LineCoverageCheck
extends CommonCheck {
    private static final double DEFAULT_MIN_RATIO = 65.0;
    @RuleProperty(key="minimumLineCoverageRatio", description="The minimum required line coverage ratio.", defaultValue="65.0")
    private double minimumLineCoverageRatio = 65.0;

    @Override
    public void checkResource(Resource resource, DecoratorContext context, Rule rule) {
        double lineCoverage = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.LINE_COVERAGE), (Double)0.0);
        if (context.getMeasure(CoreMetrics.LINE_COVERAGE) != null && lineCoverage < this.minimumLineCoverageRatio) {
            double uncoveredLines = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.UNCOVERED_LINES), (Double)0.0);
            double linesToCover = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.LINES_TO_COVER), (Double)0.0);
            double linesToCoverToReachThreshold = Math.ceil(linesToCover * this.minimumLineCoverageRatio / 100.0 - (linesToCover - uncoveredLines));
            Violation violation = this.createViolation(resource, rule, linesToCoverToReachThreshold);
            context.saveViolation(violation);
        }
    }

    private Violation createViolation(Resource resource, Rule rule, double linesToCoverToReachThreshold) {
        Violation violation = Violation.create((Rule)rule, (Resource)resource).setCost(Double.valueOf(linesToCoverToReachThreshold));
        violation.setMessage((int)linesToCoverToReachThreshold + " more lines of code need to be covered by unit tests to reach the minimum threshold of " + this.minimumLineCoverageRatio + "% lines coverage.");
        return violation;
    }

    public void setMinimumLineCoverageRatio(int threshold) {
        this.minimumLineCoverageRatio = threshold;
    }
}

