/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.Violation;
import org.sonar.check.Priority;
import org.sonar.commonrules.internal.checks.CommonCheck;

@org.sonar.check.Rule(key="SkippedUnitTests", name="Skipped unit tests", priority=Priority.MAJOR, description="<p>Skipped unit tests are considered as dead code. Either they should be activated again (and updated) or they should be removed.</p>")
public class SkippedUnitTestsCheck
extends CommonCheck {
    @Override
    public void checkResource(Resource resource, DecoratorContext context, Rule rule) {
        double skippedTests = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.SKIPPED_TESTS), (Double)0.0);
        if (ResourceUtils.isUnitTestClass((Resource)resource) && skippedTests > 0.0) {
            Violation violation = Violation.create((Rule)rule, (Resource)resource).setCost(Double.valueOf(skippedTests));
            violation.setMessage("Some tests are skipped. You should activate them or remove them.");
            context.saveViolation(violation);
        }
    }
}

