/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.commons.configuration;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.commons.database.DatabaseProperties;

import javax.persistence.*;

@Entity
@Table(name = "properties")
public class Property {

  @Id
  @Column(name = "id")
  @SequenceGenerator(name = "PROPERTIES_SEQ", sequenceName = "PROPERTIES_SEQ")
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "PROPERTIES_SEQ")
  private Integer id;

  @Column(name = "prop_key", updatable = true, nullable = true)
  private String key;

  @Column(name = "prop_value", updatable = true, nullable = true, length = DatabaseProperties.MAX_TEXT_SIZE)
  private String value;

  @Column(name = "resource_id", updatable = true, nullable = true)
  private Integer resourceId;

  public Property(String key, String value) {
    this.key = key;
    this.value = value;
  }

  public Property(String key, String value, Integer resourceId) {
    this.key = key;
    this.value = value;
    this.resourceId = resourceId;
  }

  public Property() {
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public Integer getResourceId() {
    return resourceId;
  }

  public void setResourceId(Integer resourceId) {
    this.resourceId = resourceId;
  }

  @Override
  public boolean equals(Object obj) {
    if (!(obj instanceof Property)) {
      return false;
    }
    if (this == obj) {
      return true;
    }
    Property other = (Property) obj;
    return new EqualsBuilder()
      .append(key, other.getKey())
      .append(resourceId, other.getResourceId())
      .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder(17, 37)
      .append(key)
      .append(resourceId)
      .toHashCode();
  }

  @Override
  public String toString() {
    return new ToStringBuilder(this)
      .append("key", key)
      .append("resource", resourceId)
      .append("value", value)
      .toString();
  }
}
