/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.commons.configuration;

import org.apache.commons.configuration.BaseConfiguration;
import org.sonar.commons.database.DatabaseSession;
import org.sonar.commons.resources.Resource;

import java.util.List;

public class ResourceDatabaseConfiguration extends BaseConfiguration {
  private DatabaseSession session;
  private Resource resource;

  public ResourceDatabaseConfiguration(DatabaseSession session, Resource resource) {
    this.session = session;
    this.resource = resource;
    load();
  }

  public void load() {
    clear();

    // order is important : resource props override global props
    loadGlobalProperties();
    loadResourceProperties();
  }

  private void loadResourceProperties() {
    if (resource != null && resource.getId() != null) {
      List<Property> properties = session
          .createQuery("from " + Property.class.getSimpleName() + " p where p.resourceId=:resourceId")
          .setParameter("resourceId", resource.getId())
          .getResultList();

      registerProperties(properties);
    }
  }

  private void registerProperties(List<Property> properties) {
    if (properties != null) {
      for (Property property : properties) {
        setProperty(property.getKey(), property.getValue());
      }
    }
  }

  private void loadGlobalProperties() {
    List<Property> properties = session
        .createQuery("from " + Property.class.getSimpleName() + " p where p.resourceId is null")
        .getResultList();

    registerProperties(properties);
  }

}
