/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.commons.database;

public class DatabaseProperties {
  public static final int MAX_TEXT_SIZE = 16777215;

  public static final String PROP_ISOLATION = "sonar.jdbc.defaultTransactionIsolation";
  public static final String PROP_URL = "sonar.jdbc.url";
  public static final String PROP_DRIVER = "sonar.jdbc.driver";
  public static final String PROP_USER = "sonar.jdbc.user";
  public static final String PROP_PASSWORD = "sonar.jdbc.password";
  public static final String PROP_HIBERNATE_SECOND_LEVEL_CACHE = "sonar.jdbc.hibernateSecondLevelCache";
  public static final String PROP_DIALECT = "sonar.jdbc.dialect";
  public static final String PROP_DIALECT_CLASS = "sonar.jdbc.dialectClass";
  public static final String PROP_JNDI_NAME = "sonar.jdbc.jndiName";
  public static final String PROP_EMBEDDED_PORT = "sonar.embeddedDatabase.port";
  public static final String PROP_EMBEDDED_DATA_DIR = "sonar.embeddedDatabase.dataDir";


  public static final String DIALECT_DERBY = "derby";
  public static final String DIALECT_HSQLDB = "hsqldb";
  public static final String DIALECT_ORACLE = "oracle";
  public static final String DIALECT_DB2 = "db2";
  public static final String DIALECT_MYSQL = "mysql";
  public static final String DIALECT_MSSQL = "mssql";
  public static final String DIALECT_POSTGRE = "postgresql";
}