/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.commons.database;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;

import javax.persistence.EntityManager;
import java.sql.Connection;

public class InMemoryDatabaseConnector extends DriverDatabaseConnector {
  public static final String DRIVER = "org.hsqldb.jdbcDriver";
  public static final String URL = "jdbc:hsqldb:mem:sonar";
  public static final String USER = "sa";
  public static final String PASSWORD = null;
  public static final int ISOLATION = Connection.TRANSACTION_READ_UNCOMMITTED;

  private int version = -1;


  public InMemoryDatabaseConnector(int version, boolean createSchema) {
    this(getInMemoryConfiguration(), version, createSchema);
  }

  public InMemoryDatabaseConnector() {
    this(getInMemoryConfiguration(), SchemaInfo.VERSION, true);
  }

  public InMemoryDatabaseConnector(Configuration configuration, int version, boolean createSchema) {
    super(configuration);
    this.version = version;
    if (createSchema) {
     setHbm2ddl("create-drop"); 
    }
  }

  protected static Configuration getInMemoryConfiguration() {
    PropertiesConfiguration conf = new PropertiesConfiguration();
    conf.setProperty(DatabaseProperties.PROP_URL, URL);
    conf.setProperty(DatabaseProperties.PROP_DRIVER, DRIVER);
    conf.setProperty(DatabaseProperties.PROP_USER, USER);
    conf.setProperty(DatabaseProperties.PROP_PASSWORD, PASSWORD);
    conf.setProperty(DatabaseProperties.PROP_ISOLATION, ISOLATION);
    conf.setProperty(DatabaseProperties.PROP_HIBERNATE_SECOND_LEVEL_CACHE, false);
    return conf;
  }

  public void start() {
    if (version >= 0) {
      getEntityManagerFactory();
      populateDatabase();
    }
  }

  private void populateDatabase() {
    SchemaInfo schemaInfo = new SchemaInfo();
    schemaInfo.setVersion(version);
    EntityManager manager = null;
    try {
      manager = createEntityManager();
      manager.getTransaction().begin();
      manager.persist(schemaInfo);
      manager.getTransaction().commit();

    } finally {
      if (manager != null) {
        manager.close();
      }
    }
  }
}