/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.commons.resources;

import org.sonar.commons.Metric;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.commons.rules.Rule;

public class MeasureKey implements Cloneable {
  protected Metric metric;
  protected Integer rulesCategoryId;
  protected Rule rule;

  public MeasureKey(Metric metric, Integer categoryId) {
    this.metric = metric;
    this.rulesCategoryId = categoryId;
    this.rule = null;
  }

  public MeasureKey(Metric metric, Rule rule) {
    this.metric = metric;
    if (rule != null && rule.getRulesCategory() != null) {
      this.rulesCategoryId = rule.getRulesCategory().getId();
    }
    this.rule = rule;
  }

  public MeasureKey(Metric metric) {
    this.metric = metric;
    this.rulesCategoryId = null;
    this.rule = null;
  }

  public MeasureKey(Measure measure) {
    this(measure.getMetric(), measure.getRule());
  }

  public MeasureKey(Metric metric, Integer rulesCategoryId, Rule rule) {
    this.metric = metric;
    this.rulesCategoryId = rulesCategoryId;
    this.rule = rule;
  }

  public boolean equals(Object obj) {
    if (!(obj instanceof MeasureKey)) {
      return false;
    }
    if (this == obj) {
      return true;
    }
    MeasureKey other = (MeasureKey) obj;
    return new EqualsBuilder().
        append(metric, other.metric).
        append(rulesCategoryId, other.rulesCategoryId).
        append(rule, other.rule).
        isEquals();
  }

  public int hashCode() {
    return new HashCodeBuilder(17, 37).
        append(metric).
        append(rulesCategoryId).
        append(rule).
        toHashCode();
  }

  public Object clone() {
    return new MeasureKey(this.metric, this.rulesCategoryId, this.rule);
  }


  public Metric getMetric() {
    return metric;
  }

  public MeasureKey setMetric(Metric metric) {
    this.metric = metric;
    return this;
  }

  public Integer getRulesCategoryId() {
    return rulesCategoryId;
  }

  public MeasureKey setRulesCategoryId(Integer id) {
    this.rulesCategoryId = id;
    return this;
  }

  public Rule getRule() {
    return rule;
  }

  public MeasureKey setRule(Rule rule) {
    this.rule = rule;
    return this;
  }

}