/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.commons.resources;

import org.apache.commons.lang.StringUtils;

import javax.persistence.*;
import java.io.Serializable;

@Entity(name = "ProjectLink")
@Table(name = "project_links")
public class ProjectLink implements Serializable {

  public static final int NAME_COLUMN_SIZE = 128;
  public static final int HREF_COLUMN_SIZE = 2048;

  public static final String LINK_HOME_PAGE = "homepage";
  public static final String LINK_CONTINUOUS_INTEGRATION = "ci";
  public static final String LINK_ISSUES_TRACKER = "issue";
  public static final String LINK_SCM_URL = "scm";
  public static final String LINK_SCM_RO_CONNECTION = "scm_ro";
  public static final String LINK_SCM_DEV_CONNECTION = "scm_dev";

  private static final long serialVersionUID = 3473761819014871039L;

  @Id
  @Column(name = "id")
  @SequenceGenerator(name = "PROJECT_LINKS_SEQ", sequenceName = "PROJECT_LINKS_SEQ")
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "PROJECT_LINKS_SEQ")
  private Integer id;

  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "project_id", updatable = false, nullable = false)
  private Resource resource;

  @Column(name = "link_type", updatable = true, nullable = true, length = 20)
  private String type;

  @Column(name = "name", updatable = true, nullable = true, length = NAME_COLUMN_SIZE)
  private String name;

  @Column(name = "href", updatable = true, nullable = false, length = HREF_COLUMN_SIZE)
  private String href;

  public ProjectLink() {
  }

  public ProjectLink(String type, String name, String href) {
    this.type = type;
    setName(name);
    setHref(href);
  }

  public ProjectLink(Resource resource, String type, String name, String href) {
    this.resource = resource;
    this.type = type;
    this.name = name;
    this.href = href;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public Resource getResource() {
    return resource;
  }

  public void setResource(Resource resource) {
    this.resource = resource;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = StringUtils.abbreviate(name, NAME_COLUMN_SIZE);
  }

  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = StringUtils.abbreviate(href, HREF_COLUMN_SIZE);
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }
}