/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.commons.rules;

import org.sonar.commons.resources.Snapshot;

import javax.persistence.*;

@Entity
@Table(name = "rule_failure_params")
public class RuleFailureParam {
  
  public static final int PARAM_KEY_COLUMN_SIZE = 100;
  
  @Id
  @Column(name = "id")
  @SequenceGenerator(name= "RULE_FAILURE_PARAMS_SEQ", sequenceName = "RULE_FAILURE_PARAMS_SEQ")
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "RULE_FAILURE_PARAMS_SEQ")
  private Integer id;

  @Column(name = "param_key", updatable = false, nullable = false, length = PARAM_KEY_COLUMN_SIZE)
  private String key;

  @Column(name = "value", updatable = false, nullable = true, precision = 30, scale = 20)
  private Double value;

  @Column(name = "value2", updatable = false, nullable = true, precision = 30, scale = 20)
  private Double value2;

  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "rule_failure_id")
  private RuleFailure ruleFailure;

  @Column(name = "snapshot_id")
  protected Integer snapshotId;

  public RuleFailureParam(String key, Double value, Double value2) {
    setKey(key);
    this.value = value;
    this.value2 = value2;
  }

  public RuleFailureParam() {
  }

  public Integer getId() {
    return id;
  }

  public void setId( Integer id ) {
    this.id = id;
  }

  public void setSnapshot(Snapshot snapshot) {
    this.snapshotId = snapshot.getId();
  }

  public RuleFailure getRuleFailure() {
    return ruleFailure;
  }

  public void setRuleFailure(RuleFailure ruleFailure) {
    this.ruleFailure = ruleFailure;
  }

  public String getKey() {
    return key;
  }

  public void setKey( String key ) {
    if ( key.length() > PARAM_KEY_COLUMN_SIZE ) {
      throw new IllegalArgumentException("RuleFailureParam key " + key + " size too long :" + key.length());
    }
    this.key = key;
  }

  public Double getValue() {
    return value;
  }

  public void setValue( Double value ) {
    this.value = value;
  }

  public Double getValue2() {
    return value2;
  }

  public void setValue2( Double value2 ) {
    this.value2 = value2;
  }
}
