/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.commons.rules;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.persistence.*;

@Entity
@Table(name = "rules_parameters")
public class RuleParam {

  @Id
  @Column(name = "id")
  @SequenceGenerator(name = "RULES_PARAMETERS_SEQ", sequenceName = "RULES_PARAMETERS_SEQ")
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "RULES_PARAMETERS_SEQ")
  private Integer id;

  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "rule_id")
  private Rule rule;

  @Column(name = "name", updatable = true, nullable = false, length = 128)
  private String key;

  @Column(name = "description", updatable = true, nullable = false, length = 4000)
  private String description;

  @Column(name = "param_type", updatable = true, nullable = false, length = 512)
  private String type;

  // only for backward compatibility with sonar 1.4.
  // See StandardRulesXmlParser
  //private String defaultValue;

  public RuleParam() {
  }

  public RuleParam(Rule rule, String key, String description, String type) {
    this.rule = rule;
    this.key = key;
    this.description = description;
    this.type = type;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public Rule getRule() {
    return rule;
  }

  public void setRule(Rule rule) {
    this.rule = rule;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = StringUtils.defaultString(description, "");
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object obj) {
    if (!(obj instanceof RuleParam)) {
      return false;
    }
    if (this == obj) {
      return true;
    }
    RuleParam other = (RuleParam) obj;
    return new EqualsBuilder()
        .append(rule, other.getRule())
        .append(key, other.getKey()).isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder(17, 37)
        .append(rule)
        .append(key)
        .toHashCode();
  }

  @Override
  public String toString() {
    return new ToStringBuilder(this)
        .append("id", id)
        .append("key",key)
        .append("desc", description)
        .append("type", type)
        .toString();
  }
}