/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.commons.rules;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

import javax.persistence.*;

@Immutable
@Cache(usage = CacheConcurrencyStrategy.READ_ONLY)
@Entity
@Table(name = "rules_categories")
public class RulesCategory {

  @Id
  @Column(name = "id")
  @SequenceGenerator(name = "RULES_CATEGORIES_SEQ", sequenceName = "RULES_CATEGORIES_SEQ")
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "RULES_CATEGORIES_SEQ")
  private Integer id;

  @Column(name = "name", updatable = false, nullable = false)
  private String name;

  @Column(name = "description", updatable = false, nullable = true)
  private String description;

  public RulesCategory(String name) {
    this.name = name;
  }

  public RulesCategory(String name, String description) {
    this.name = name;
    this.description = description;
  }

  public RulesCategory() {
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  @Override
  public boolean equals(Object obj) {
    if (!(obj instanceof RulesCategory)) {
      return false;
    }
    if (this == obj) {
      return true;
    }
    RulesCategory other = (RulesCategory) obj;
    return new EqualsBuilder()
        .append(name, other.getName()).isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder(17, 37)
        .append(name)
        .toHashCode();
  }

  @Override
  public String toString() {
    return new ToStringBuilder(this)
        .append("id", id)
        .append("name", name)
        .append("desc", description)
        .toString();
  }

}
