/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Table(name="metrics")
@Entity(name="Metric")
public class Metric {
    @Id
    @Column(name="id")
    @SequenceGenerator(name="METRICS_SEQ", sequenceName="METRICS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="METRICS_SEQ")
    private Integer id;
    @Column(name="name", updatable=false, nullable=false, length=64)
    private String key;
    @Column(name="description", updatable=true, nullable=true, length=255)
    private String description;
    @Column(name="val_type", updatable=true, nullable=true)
    @Enumerated(value=EnumType.STRING)
    private ValueType type;
    @Column(name="direction", updatable=true, nullable=true)
    private Integer direction;
    @Column(name="domain", updatable=true, nullable=true, length=60)
    private String domain;
    @Column(name="short_name", updatable=true, nullable=true, length=64)
    private String name;
    @Column(name="qualitative", updatable=true, nullable=true)
    private Boolean qualitative = Boolean.FALSE;
    @Column(name="user_managed", updatable=true, nullable=true)
    private Boolean userManaged = Boolean.FALSE;
    @Column(name="enabled", updatable=true, nullable=true)
    private Boolean enabled = Boolean.TRUE;
    @Column(name="origin", updatable=true, nullable=true, length=3)
    @Enumerated(value=EnumType.STRING)
    private Origin origin;

    public Metric() {
    }

    public Metric(String key) {
        this(key, ValueType.INT);
    }

    public Metric(String key, ValueType type) {
        this(key, key, key, type, -1, Boolean.FALSE, null, false);
    }

    public Metric(String key, String name, String description, ValueType type, Integer direction, Boolean qualitative, String domain, boolean userManaged) {
        this.key = key;
        this.description = description;
        this.type = type;
        this.direction = direction;
        this.domain = domain;
        this.name = name;
        this.qualitative = qualitative;
        this.userManaged = userManaged;
        this.origin = Origin.JAV;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getQualitative() {
        return this.qualitative;
    }

    public void setQualitative(Boolean qualitative) {
        this.qualitative = qualitative;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ValueType getType() {
        return this.type;
    }

    public void setType(ValueType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getUserManaged() {
        return this.userManaged;
    }

    public void setUserManaged(Boolean userManaged) {
        this.userManaged = userManaged;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getDirection() {
        return this.direction;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public boolean isNumberType() {
        return ValueType.INT.equals((Object)this.type) || ValueType.FLOAT.equals((Object)this.type) || ValueType.PERCENT.equals((Object)this.type) || ValueType.BOOL.equals((Object)this.type) || ValueType.MILLISEC.equals((Object)this.type);
    }

    public boolean isTextType() {
        return ValueType.STRING.equals((Object)this.type) || ValueType.LEVEL.equals((Object)this.type);
    }

    public boolean isDataType() {
        return ValueType.DATA.equals((Object)this.type);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Metric)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Metric other = (Metric)obj;
        return this.key.equals(other.getKey());
    }

    public String toString() {
        return this.key;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Origin {
        JAV,
        GUI,
        WS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        OK("Green"),
        WARN("Orange"),
        ERROR("Red");

        private String colorName;

        private Level(String colorName) {
            this.colorName = colorName;
        }

        public String getColorName() {
            return this.colorName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueType {
        INT,
        FLOAT,
        PERCENT,
        BOOL,
        STRING,
        MILLISEC,
        DATA,
        LEVEL;

    }
}

