/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.commons.ServerApiEmptyContentException;
import org.sonar.commons.ServerApiLaunchBatchFailureException;
import org.sonar.commons.ServerConnectionException;

public class ServerHttpClient {
    private String url;
    protected static final String SERVER_API_PATH = "/api/server";
    private static final String KEY_PATH = "/api/server/key";
    private static final String VERSION_PATH = "/api/server/version";
    protected static final String BATCH_PATH = "/api/server/consolidate_snapshot";
    protected static final String MAVEN_PATH = "/deploy/maven";
    private static final int CONNECT_TIMEOUT_MILLISECONDS = 30000;
    private static final int READ_TIMEOUT_MILLISECONDS = 60000;

    public ServerHttpClient(String remoteServerUrl) {
        this.url = StringUtils.chomp((String)remoteServerUrl, (String)"/");
    }

    public ServerHttpClient(Configuration configuration) {
        this(configuration.getString("sonar.host.url", "http://localhost:9000"));
    }

    public void checkUp() {
        String exceptionLabel = "Sonar server at " + this.url + " is unreacheable. Either start it or setup the sonar.host.url maven setting if the URL is incorrect";
        try {
            if (this.getId() == null) {
                throw new ServerConnectionException(exceptionLabel);
            }
        }
        catch (ServerConnectionException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ServerConnectionException(exceptionLabel, e);
        }
    }

    public String getId() throws IOException {
        return this.executeAction(KEY_PATH);
    }

    public String getVersion() throws IOException {
        return this.executeAction(VERSION_PATH);
    }

    public void launchBatch(Integer snapshotId) {
        String batchUrl = this.url + BATCH_PATH + "/" + snapshotId;
        try {
            this.postRemoteContent(batchUrl);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't access to url : " + batchUrl);
        }
    }

    public String getMavenRepositoryUrl() {
        return this.url + MAVEN_PATH;
    }

    protected String executeAction(String action) throws ServerApiEmptyContentException, IOException {
        String result = this.getRemoteContent(this.url + action);
        if (result.trim().length() == 0) {
            throw new ServerApiEmptyContentException("Empty " + action + " returned from server");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRemoteContent(String url) throws IOException {
        HttpURLConnection conn = this.getConnection(url, "GET");
        InputStreamReader reader = new InputStreamReader((InputStream)conn.getContent());
        try {
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                throw new IOException("Status returned by url : '" + url + "' is invalid : " + statusCode);
            }
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postRemoteContent(String url) throws IOException {
        HttpURLConnection conn = this.getConnection(url, "POST");
        try {
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                throw new ServerApiLaunchBatchFailureException("Fail to launch batch on : " + url);
            }
        }
        finally {
            conn.disconnect();
        }
    }

    protected String getUrl() {
        return this.url;
    }

    private HttpURLConnection getConnection(String url, String method) throws IOException {
        URL page = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)page.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(60000);
        conn.setRequestMethod(method);
        conn.connect();
        return conn;
    }
}

