/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class WildcardPattern {
    private Pattern pattern;

    public WildcardPattern(String pattern) {
        this(pattern, "/");
    }

    public WildcardPattern(String pattern, String directorySeparator) {
        this.pattern = Pattern.compile(this.toRegexp(pattern, directorySeparator));
    }

    public boolean match(String value) {
        return this.pattern.matcher(this.removeSlahesToIgnore(value)).matches();
    }

    private String toRegexp(String wildcardPattern, String directorySeparator) {
        String pattern = this.removeSlahesToIgnore(wildcardPattern);
        pattern = StringUtils.replace((String)pattern, (String)"**/**", (String)"**");
        pattern = StringUtils.replace((String)pattern, (String)"**/", (String)"|");
        pattern = StringUtils.replace((String)pattern, (String)"/**", (String)"|");
        pattern = StringUtils.replace((String)pattern, (String)"**", (String)"|");
        StringBuilder sb = new StringBuilder();
        block7: for (char c : pattern.toCharArray()) {
            switch (c) {
                case '|': {
                    sb.append(".*");
                    continue block7;
                }
                case '*': {
                    sb.append("[^\\").append(directorySeparator).append("]*");
                    continue block7;
                }
                case '?': {
                    sb.append("[^\\").append(directorySeparator).append("]");
                    continue block7;
                }
                case '.': {
                    sb.append("\\.");
                    continue block7;
                }
                case '/': {
                    sb.append("\\").append(directorySeparator);
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private String removeSlahesToIgnore(String wildcardPattern) {
        String pattern = StringUtils.removeStart((String)wildcardPattern, (String)"/");
        pattern = StringUtils.removeEnd((String)pattern, (String)"/");
        return pattern;
    }
}

