/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.alerts;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.sonar.commons.Metric;
import org.sonar.commons.resources.Measure;
import org.sonar.commons.rules.RulesProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="alerts")
public class Alert
implements Cloneable {
    public static String OPERATOR_GREATER = ">";
    public static String OPERATOR_SMALLER = "<";
    public static String OPERATOR_EQUALS = "=";
    public static String OPERATOR_NOT_EQUALS = "!=";
    @Id
    @Column(name="id")
    @SequenceGenerator(name="ALERTS_SEQ", sequenceName="ALERTS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="ALERTS_SEQ")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="profile_id")
    @Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
    private RulesProfile rulesProfile;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="metric_id")
    @Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
    private Metric metric;
    @Column(name="operator", updatable=false, nullable=true, length=3)
    private String operator;
    @Column(name="value_error", updatable=false, nullable=true, length=64)
    private String valueError;
    @Column(name="value_warning", updatable=false, nullable=true, length=64)
    private String valueWarning;

    public Alert() {
    }

    public Alert(RulesProfile rulesProfile, Metric metric, String operator, String valueError, String valueWarning) {
        this.rulesProfile = rulesProfile;
        this.metric = metric;
        this.operator = operator;
        this.valueError = valueError;
        this.valueWarning = valueWarning;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public RulesProfile getRulesProfile() {
        return this.rulesProfile;
    }

    public void setRulesProfile(RulesProfile rulesProfile) {
        this.rulesProfile = rulesProfile;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getValueError() {
        return this.valueError;
    }

    public void setValueError(String valueError) {
        this.valueError = valueError;
    }

    public String getValueWarning() {
        return this.valueWarning;
    }

    public void setValueWarning(String valueWarning) {
        this.valueWarning = valueWarning;
    }

    public boolean isGreaterOperator() {
        return this.operator.equals(OPERATOR_GREATER);
    }

    public boolean isSmallerOperator() {
        return this.operator.equals(OPERATOR_SMALLER);
    }

    public boolean isEqualsOperator() {
        return this.operator.equals(OPERATOR_EQUALS);
    }

    public boolean isNotEqualsOperator() {
        return this.operator.equals(OPERATOR_NOT_EQUALS);
    }

    public Metric.Level getAlertLevel(Measure measure) {
        if (this.evaluateAlert(measure, Metric.Level.ERROR)) {
            return Metric.Level.ERROR;
        }
        if (this.evaluateAlert(measure, Metric.Level.WARN)) {
            return Metric.Level.WARN;
        }
        return Metric.Level.OK;
    }

    private boolean evaluateAlert(Measure measure, Metric.Level alertLevel) {
        String valueToEval;
        if (alertLevel.equals((Object)Metric.Level.ERROR)) {
            valueToEval = this.getValueError();
        } else if (alertLevel.equals((Object)Metric.Level.WARN)) {
            valueToEval = this.getValueWarning();
        } else {
            throw new IllegalStateException(alertLevel.toString());
        }
        if (StringUtils.isEmpty((String)valueToEval)) {
            return false;
        }
        Comparable<?> criteriaValue = this.getValueForComparison(this.getMetric(), valueToEval);
        Comparable<?> metricValue = this.getMeasureValue(this.getMetric(), measure);
        int comparison = metricValue.compareTo(criteriaValue);
        return !(this.isNotEqualsOperator() && comparison == 0 || this.isGreaterOperator() && comparison != 1 || this.isSmallerOperator() && comparison != -1) && (!this.isEqualsOperator() || comparison == 0);
    }

    public String getAlertLabel(Metric.Level level) {
        return this.getMetric().getName() + " " + this.getOperator() + " " + (level.equals((Object)Metric.Level.ERROR) ? this.getValueError() : this.getValueWarning());
    }

    private Comparable<?> getValueForComparison(Metric metric, String value) {
        if (metric.getType() == Metric.ValueType.FLOAT || metric.getType() == Metric.ValueType.PERCENT) {
            return Double.parseDouble(value);
        }
        if (metric.getType() == Metric.ValueType.INT || metric.getType() == Metric.ValueType.MILLISEC) {
            return value.contains(".") ? Integer.parseInt(value.substring(0, value.indexOf(46))) : Integer.parseInt(value);
        }
        if (metric.getType() == Metric.ValueType.STRING || metric.getType() == Metric.ValueType.LEVEL) {
            return value;
        }
        if (metric.getType() == Metric.ValueType.BOOL) {
            return Boolean.valueOf(value);
        }
        throw new NotImplementedException(metric.getType().toString());
    }

    private Comparable<?> getMeasureValue(Metric metric, Measure measure) {
        if (metric.getType() == Metric.ValueType.FLOAT || metric.getType() == Metric.ValueType.PERCENT) {
            return measure.getValue();
        }
        if (metric.getType() == Metric.ValueType.INT || metric.getType() == Metric.ValueType.MILLISEC) {
            return measure.getValue().intValue();
        }
        if (metric.getType() == Metric.ValueType.STRING || metric.getType() == Metric.ValueType.LEVEL) {
            return measure.getTextValue();
        }
        if (metric.getType() == Metric.ValueType.BOOL) {
            return measure.getValue() == 0.0 ? Boolean.FALSE : Boolean.TRUE;
        }
        throw new NotImplementedException(metric.getType().toString());
    }

    public Object clone() {
        return new Alert(this.getRulesProfile(), this.getMetric(), this.getOperator(), this.getValueError(), this.getValueWarning());
    }
}

