/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commons.configuration;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@Entity
@Table(name="properties")
public class Property {
    @Id
    @Column(name="id")
    @SequenceGenerator(name="PROPERTIES_SEQ", sequenceName="PROPERTIES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="PROPERTIES_SEQ")
    private Integer id;
    @Column(name="prop_key", updatable=true, nullable=true)
    private String key;
    @Column(name="prop_value", updatable=true, nullable=true, length=0xFFFFFF)
    private String value;
    @Column(name="resource_id", updatable=true, nullable=true)
    private Integer resourceId;

    public Property(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public Property(String key, String value, Integer resourceId) {
        this.key = key;
        this.value = value;
        this.resourceId = resourceId;
    }

    public Property() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Property)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Property other = (Property)obj;
        return new EqualsBuilder().append((Object)this.key, (Object)other.getKey()).append((Object)this.resourceId, (Object)other.getResourceId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.key).append((Object)this.resourceId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.key).append("resource", (Object)this.resourceId).append("value", (Object)this.value).toString();
    }
}

